from sandbox import sdk2

from sandbox.projects.pcode.qa.resource_types import PCODE_RR_REQUEST_LOG_GZ, \
    PCODE_RR_CACHE_DAEMON_STUB_DATA, PCODE_JANPU_REQUEST_LOG_GZ, PCODE_JANPU_CACHE_DAEMON_STUB_DATA


GRAPH_NAMES = {
    "pcode_report_renderer__pcode": {
        "requestlog_resource": PCODE_RR_REQUEST_LOG_GZ,
        "cache_daemon_stub_data": PCODE_RR_CACHE_DAEMON_STUB_DATA,
    },
    "pcode_report_renderer__pcode_backend": {
        "requestlog_resource": PCODE_RR_REQUEST_LOG_GZ,
        "cache_daemon_stub_data": PCODE_RR_CACHE_DAEMON_STUB_DATA,
    },
    "janpu__mobileadssdk": {
        "requestlog_resource": PCODE_JANPU_REQUEST_LOG_GZ,
        "cache_daemon_stub_data": PCODE_JANPU_CACHE_DAEMON_STUB_DATA,
    },
    "janpu__mobileadssdk_startup": {
        "requestlog_resource": PCODE_JANPU_REQUEST_LOG_GZ,
        "cache_daemon_stub_data": PCODE_JANPU_CACHE_DAEMON_STUB_DATA,
    },
}


class PcodePrepareAmmoResources(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):

        graph_name = sdk2.parameters.String(
            "Select graph name to prepare ammo resources", required=True,
            choices=[(c,) * 2 for c in GRAPH_NAMES.keys()]
        )

        testenv_switch_trigger_value = sdk2.parameters.Integer(
            "Pin testenv_switch_trigger version",
            default_value=0
        )

        with sdk2.parameters.Output:
            requestlog_resource = sdk2.parameters.Resource('RequestLog resource')
            cache_daemon_stub_data = sdk2.parameters.Resource('CacheDaemon resource')

    def on_execute(self):
        graph_name = self.Parameters.graph_name
        testenv_switch_trigger_name = "testenv_switch_trigger_" + graph_name
        if self.Parameters.testenv_switch_trigger_value:
            self.Parameters.requestlog_resource = sdk2.Resource.find(
                resource_type=GRAPH_NAMES[graph_name]["requestlog_resource"],
                attrs={
                    testenv_switch_trigger_name: self.Parameters.testenv_switch_trigger_value
                }
            ).first()
            self.Parameters.cache_daemon_stub_data = sdk2.Resource.find(
                resource_type=GRAPH_NAMES[graph_name]["cache_daemon_stub_data"],
                attrs={
                    testenv_switch_trigger_name: self.Parameters.testenv_switch_trigger_value
                }
            ).first()
        else:
            self.Parameters.requestlog_resource = sdk2.Resource.find(
                resource_type=GRAPH_NAMES[graph_name]["requestlog_resource"],
                attr_name=testenv_switch_trigger_name
            ).first()
            self.Parameters.cache_daemon_stub_data = sdk2.Resource.find(
                resource_type=GRAPH_NAMES[graph_name]["cache_daemon_stub_data"],
                attr_name=testenv_switch_trigger_name
            ).first()
