from sandbox import sdk2
from sandbox.common.types.misc import DnsType
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox import (
    AmmoRequestlogModuleGeneralSandboxAdapter, parameters
)
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.task_factory.simple_shoot_task import factory as simple_shoot_task_factory
from sandbox.projects.yabs.qa.yt_uploader_module.adapters.sandbox import ShootResultsYtUploaderGenericSandboxAdapter

from sandbox.projects.pcode.qa.report_renderer.pcode_graph_sut.adapters.sandbox import PCodeGraphSUTSandboxAdapter
from sandbox.projects.pcode.qa.resource_types import PCODE_RR_REQUEST_LOG_GZ, PcodeRendererResponseDump


CONTAINER_RESOURCE = 2090878873


class AmmoRequestLogPcodeParameters(parameters.AmmoRequestlogGeneralParameters):
    requestlog_resource = sdk2.parameters.Resource('Requestlog resource',
                                                   resource_type=PCODE_RR_REQUEST_LOG_GZ)


class AmmoRequestlogWithRepeatedQueryargsAdapter(AmmoRequestlogModuleGeneralSandboxAdapter):
    def __init__(self, parameters, task_instance):
        AmmoRequestlogModuleGeneralSandboxAdapter.__init__(
            self, parameters, task_instance, allow_repeated_queryargs=True
        )

    @staticmethod
    def get_init_parameters_class():
        return AmmoRequestLogPcodeParameters


class PCodeRendererGraphSimpleShootTask(
    simple_shoot_task_factory(
        PCodeGraphSUTSandboxAdapter,
        AmmoRequestlogWithRepeatedQueryargsAdapter,
        DolbiloModuleSandboxAdapter,
        PcodeRendererResponseDump,
        'PCODE_RENDERER_GRAPH',
        ShootResultsYtUploaderGenericSandboxAdapter,
    )
):
    class Requirements(sdk2.Requirements):
        container_resource = CONTAINER_RESOURCE
        dns = DnsType.DNS64
