from sandbox import sdk2

from sandbox.projects.yabs.qa.tasks.BuildAmmoAndStubsFromYT import BuildAmmoAndStubsFromYT
from sandbox.projects.pcode.qa.resource_types import PCODE_RR_DOLBILKA_PLAN, PCODE_RR_REQUEST_LOG_GZ, \
    PCODE_RR_CACHE_DAEMON_STUB_DATA, PCODE_JANPU_DOLBILKA_PLAN, PCODE_JANPU_REQUEST_LOG_GZ, PCODE_JANPU_CACHE_DAEMON_STUB_DATA

DOLBILKA_PLAN_RESOURCES = [
    PCODE_RR_DOLBILKA_PLAN,
    PCODE_JANPU_DOLBILKA_PLAN,
]

REQUEST_LOG_GZ_RESOURCES = [
    PCODE_RR_REQUEST_LOG_GZ,
    PCODE_JANPU_REQUEST_LOG_GZ,
]

CACHE_DAEMON_STUB_DATA_RESOURCES = [
    PCODE_RR_CACHE_DAEMON_STUB_DATA,
    PCODE_JANPU_CACHE_DAEMON_STUB_DATA,
]


class PcodeBuildAmmoAndStubsFromYT(BuildAmmoAndStubsFromYT):

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 32 * 1024
        disk_space = 40960

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(BuildAmmoAndStubsFromYT.Parameters):
        max_restarts = 1
        # output resource types

        dolbilka_plan_resource_type = sdk2.parameters.String("Resource type for dolbilka_plan", required=True,
                                                             choices=[(c.name,) * 2
                                                                      for c in DOLBILKA_PLAN_RESOURCES])
        request_log_gz_resource_type = sdk2.parameters.String("Resource type for request_log_gz", required=True,
                                                              choices=[(c.name,) * 2
                                                                       for c in REQUEST_LOG_GZ_RESOURCES])
        cache_daemon_stub_resource_type = sdk2.parameters.String("Resource type for cache_daemon_stub", required=True,
                                                                 choices=[(c.name,) * 2
                                                                          for c in CACHE_DAEMON_STUB_DATA_RESOURCES])

        yt_token_vault_name = sdk2.parameters.String("Vault name to get YT token from", default="ANTIADBLOCK_YT_TOKEN")
        legacy_mode = sdk2.parameters.Bool('Legacy mode', default_value=True)
        with legacy_mode.value[True]:
            key_header = sdk2.parameters.String("Key header for ammo and cachedaemon", default_value='X-YABS-NANPU-REQ-ID')
