import logging
import urllib2
import time


def wait_ping(url, timeout=300, max_pause=None):
    deadline = time.time() + timeout
    pause = 0.25
    request = urllib2.Request(url)
    while True:
        try:
            urllib2.urlopen(request, timeout=10)
        except urllib2.HTTPError as e:
            error_msg = "%s returned %d" % (url, e.code)
        except Exception as e:
            error_msg = "%s exception: %s" % (url, str(e))
        else:
            break

        now = time.time()
        if now > deadline:
            raise RuntimeError("No 200 response after %s seconds (url %s): %s" % (timeout, url, error_msg))
        logging.info(error_msg)
        time.sleep(pause)
        pause *= 1.5
        if max_pause:
            pause = min(pause, max_pause)
        logging.info("Retrying %s ..." % url)

    logging.info("Obtained 200 response on url %s" % url)
