from sandbox import sdk2


DEFAULT_TTL = 30


class PcodeLoaderBundleResource(sdk2.Resource):
    """
    Base PCODE loader bundle resources
    """
    releasable = True
    any_arch = True
    auto_backup = True
    ttl = DEFAULT_TTL
    group = 'PCODE'
    releasers = ['PCODE']
    release_subscribers = ['PCODE']


class PcodeLoaderSuperbundle(PcodeLoaderBundleResource):
    pass


class PcodeWidgetSuperbundle(PcodeLoaderBundleResource):
    pass


class PcodeVasSuperbundle(PcodeLoaderBundleResource):
    pass


class MobileAdsSdkServiceResource(sdk2.Resource):
    """
    Mobile Ads Sdk Service Resources
    """
    releasable = True
    any_arch = True
    auto_backup = True
    ttl = 365
    group = 'YANDEX_MOBILEADS_SDK'
    releasers = ['YANDEX_MOBILEADS_SDK', 'ANTIADBLOCK']
    release_subscribers = ['YANDEX_MOBILEADS_SDK', 'ANTIADBLOCK']


class PcodeGenerateAmmoStubBin(sdk2.Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'PCODE'
    releasers = ['PCODE']
    release_subscribers = ["PCODE"]


class PcodePreparePhantomRequestsBin(sdk2.Resource):
    releaseable = True
    any_arch = True
    auto_backup = True
    group = 'PCODE'
    releasers = ['PCODE', 'ANTIADBLOCK']
    release_subscribers = ['PCODE', 'ANTIADBLOCK']


class PcodeGeneratePerfAmmoBin(sdk2.Resource):
    releaseable = True
    any_arch = True
    auto_backup = True
    group = 'PCODE'
    releasers = ['PCODE', 'ANTIADBLOCK']
    release_subscribers = ['PCODE', 'ANTIADBLOCK']


class PcodeSplitAmmoTableBin(sdk2.Resource):
    releaseable = True
    any_arch = True
    auto_backup = True
    group = 'PCODE'
    releasers = ['PCODE']
    release_subscribers = ["PCODE"]
