# coding=utf-8

import logging


def update_aggregate(juggler_host, common_settings, settings, juggler_token):
    from adv.pcode.zfp.utils.juggler import create_aggregates
    from antiadblock.tasks.tools.juggler import create_aggregate_checks

    logging.info("Update juggler host: {}".format(juggler_host))

    aggregates = create_aggregates(juggler_host, common_settings, settings)

    for mark, checks in aggregates.items():
        create_aggregate_checks(checks, mark, juggler_token=juggler_token)

    logging.info("Update juggler host success: {}".format(juggler_host))
