import logging
from urlparse import urljoin

import requests


def update_alert(alert_id, common_settings, aggregate_settings, alert_settings, template_path, solomon_token, use_prestable=False):
    from adv.pcode.zfp.utils.solomon import get_aggregates, generate_program, generate_annotations, get_empty_alert_params, update_alert_params

    project = common_settings["solomon"]["project"]
    logging.info("Update solomon alert: {}".format(alert_id))
    SOLOMON_BASE_URL = 'solomon-prestable.yandex-team.ru' if use_prestable else 'solomon.yandex-team.ru'
    SOLOMON_API_BASE_URL = 'https://{}/api/v2/projects/{}/'.format(SOLOMON_BASE_URL, project)
    SOLOMON_HEADERS = {'Authorization': 'OAuth {}'.format(solomon_token),
                       'Content-Type': 'application/json', 'Accept': 'application/json'}
    SOLOMON_ALERTS_API_URL = urljoin(SOLOMON_API_BASE_URL, 'alerts/')

    aggregates = get_aggregates(aggregate_settings)
    program = generate_program(template_path, common_settings, alert_settings["program"], aggregates)
    annotations = generate_annotations(alert_id, alert_settings, aggregates)

    session = requests.Session()
    session.headers.update(SOLOMON_HEADERS)

    action = ""
    response = session.get(urljoin(SOLOMON_ALERTS_API_URL, alert_id))
    request_data = {}
    if response.status_code == 200:
        alert_params = response.json()
        request_data = update_alert_params(alert_params, alert_settings, program, aggregates, annotations)
        response = session.put(
            urljoin(SOLOMON_ALERTS_API_URL, alert_id),
            json=request_data,
        )
        action = "Update"
    elif response.status_code == 404:
        request_data = update_alert_params(get_empty_alert_params(project, alert_id), alert_settings, program, aggregates, annotations)
        response = session.post(
            SOLOMON_ALERTS_API_URL,
            json=request_data,
        )
        action = "Create"

    if response.status_code != 200:
        logging.info(response.text)
        logging.info(request_data)

    response.raise_for_status()
    logging.info("{} alert success: {}".format(action, alert_id))
