def validate_params(params, alert, update_solomon_alerts=True, update_juggler_aggregates=True):
    errors = []
    # validate section exists
    for key in ("common_settings", "alert_settings"):
        if key not in params:
            errors.append('Key "{}" not found in params.yaml for alert {}'.format(key, alert))
    # validate common_settings
    if "common_settings" in params:
        errors.extend(validate_common_settings(alert, params["common_settings"]))
    alert_settings = params.get("alert_settings", {})
    # validate alert settings
    for alert_name, settings in alert_settings.items():
        if "aggregate" not in settings:
            errors.append('Key "aggregate" not found in params.yaml for alert {}'.format(alert_name))
        if "solomon" not in settings and update_solomon_alerts:
            errors.append('Key "solomon" not found in params.yaml for alert {}'.format(alert_name))
        if "juggler" not in settings and update_juggler_aggregates:
            errors.append('Key "juggler" not found in params.yaml for alert {}'.format(alert_name))

        if "solomon" in settings and update_solomon_alerts:
            errors.extend(validate_alert_solomon_settings(alert_name, settings["solomon"]))

    return errors


def _validate_settings(alert_name, settings, validate_keys, settings_name):
    errors = []
    for key, val in validate_keys.items():
        if key not in settings:
            if val["required"]:
                errors.append('Key "{}" not found in **{}** for alert **{}**'.format(key, settings_name, alert_name))
        elif not isinstance(settings[key], val["type"]):
            errors.append('Key "{}" is bad type in **{}** for alert **{}**, expected **{}**'.format(key, settings_name, alert_name, val["type"]))
        else:
            for subkey, v in val.get("subkeys", {}).items():
                if subkey not in settings[key]:
                    if v["required"]:
                        errors.append('Key "{}.{}" not found in **{}** for alert **{}**'.format(key, subkey, settings_name, alert_name))
                elif not isinstance(settings[key][subkey], v["type"]):
                    errors.append('Key "{}.{}" is bad type in **{}** for alert **{}**, expected **{}**'.format(key, subkey, settings_name, alert_name, v["type"]))

    return errors


def validate_common_settings(alert_name, common_settings):
    keys = {
        "solomon": {
            "required": True,
            "type": dict,
            "subkeys": {
                "project": {
                    "required": True,
                    "type": str,
                },
                "cluster": {
                    "required": True,
                    "type": str,
                },
            },
        },
        "juggler": {
            "required": True,
            "type": dict,
            "subkeys": {
                "namespace": {
                    "required": True,
                    "type": str,
                },
            },
        },
        "st_queue": {
            "required": False,
            "type": dict,
            "subkeys": {
                "name": {
                    "required": True,
                    "type": str,
                },
            },
        },
    }
    return _validate_settings(alert_name, common_settings, keys, settings_name="common_settings")


def validate_alert_solomon_settings(alert_name, solomon_settings):
    keys = {
        "period": {
            "required": True,
            "type": str,
        },
        "channel": {
            "required": True,
            "type": str,
        },
        "program": {
            "required": True,
            "type": dict,
            "subkeys": {
                "name": {
                    "required": True,
                    "type": str,
                },
            },
        },
    }
    return _validate_settings(alert_name, solomon_settings, keys, settings_name="solomon settings")
