# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import logging
import sandbox.projects.resource_types as resource_types
from sandbox.projects.common.search.database.iss_shards import _get_iss_shards_tool
import os

peoplesearch_releasers = ['nkmakarov', 'iv-ivan']


class PPLImagesShard(sdk2.Resource):
    releasable = True
    releasers = peoplesearch_releasers
    shard_index = sdk2.Attributes.Integer("Shard index")
    timestamp = sdk2.Attributes.Integer("Creation timestamp")
    shard = True
    auto_backup = True


class BuildPPLImagesOneShard(sdk2.Task):
    class Requirements(sdk2.Requirements):
        ram = 10000
        disk_space = 103000

    class Parameters(sdk2.Task.Parameters):
        index_prefix = sdk2.parameters.String('YT path to index', required=True)
        index_state = sdk2.parameters.String('Index state', required=True)
        shard = sdk2.parameters.Integer('Shard index', required=True)
        timestamp = sdk2.parameters.Integer('Shard timestamp', required=True)
        yt_server = sdk2.parameters.String('YT server short name', default="banach")
        yt_token_secret_name = sdk2.parameters.String('YT token vault secret', required=True)
        shardwriter = sdk2.parameters.Resource("Shardwriter resource", resource_type=resource_types.IMAGES_MR_INDEX_SHARDWRITER, required=True)
        images_shard = sdk2.parameters.Resource("Images shard resource", resource_type=resource_types.IMAGES_SEARCH_DATABASE, required=True)

    def on_execute(self):
        shardwriter_data = sdk2.ResourceData(self.Parameters.shardwriter)
        shardwriter_path = shardwriter_data.path
        shard_data = sdk2.ResourceData(self.Parameters.images_shard)
        shard_path = shard_data.path

        # preparing shard
        shard_name = "peopleimages-%03d-%s-1" % (self.Parameters.shard, self.Parameters.timestamp)
        resource = sdk2.ResourceData(PPLImagesShard(self, "PPL images shard", shard_name, shard_index=self.Parameters.shard, timestamp=self.Parameters.timestamp))
        yt_token = sdk2.Vault.data(self.Parameters.yt_token_secret_name)
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("writing")) as pl:
            status = sp.Popen("mkdir {}".format(resource.path), shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            for filename in ["indexaa", "indexmeta", "indexporn", "stamp_cbir.TAG"]:
                status = sp.Popen("cp {} {}".format(os.path.join(str(shard_path), filename), resource.path), shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
                if status != 0:
                    raise Exception("Can't copy " + filename)
            status = sp.Popen("chmod -R +w {}".format(resource.path), shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            if status != 0:
                raise Exception("Can't chmod")
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("writing")) as pl:
            status = sp.Popen(
                "YT_TOKEN={} MR_RUNTIME=YT {} WriteSimShard --server {} --index-prefix {} --index-state {} --index-shard-number {} --transactionid 0 --out-dir {}".format(
                    yt_token, shardwriter_path, self.Parameters.yt_server, self.Parameters.index_prefix, self.Parameters.index_state, self.Parameters.shard, resource.path
                ),
                shell=True, stdout=pl.stdout, stderr=sp.STDOUT
            ).wait()
            if status != 0:
                raise Exception("Can't write shard")
        resource.path.joinpath("index_list").write_bytes("indexface_v4")

        # register shard
        iss_shards = sdk2.ResourceData(sdk2.Resource.find(id=_get_iss_shards_tool()).first())
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("iss_shards")) as pl:
            status = sp.Popen("{} configure {} --id {}".format(iss_shards.path, resource.path, shard_name), shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            if status != 0:
                raise Exception("Can't configure shard")
            status = sp.Popen("{} register {}".format(iss_shards.path, resource.path), shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            if status != 0:
                raise Exception("Can't register shard")
        resource.ready()
