# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

peoplesearch_releasers = ['nkmakarov', 'iv-ivan', 'asanikushin', 'ustas']


class PeoplesearchScripts(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = peoplesearch_releasers


class BuildPeoplesearchScripts(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        revision = sdk2.parameters.Integer('Arcadia revision number', required=True)

    def on_execute(self):
        archive_folder = sdk2.path.Path('out')
        archive_folder.mkdir()

        sdk2.svn.Arcadia.export(
            sdk2.svn.Arcadia.trunk_url('yweb/peoplesearch/aurora_exchange/scripts'),
            str(archive_folder),
            revision=self.Parameters.revision
        )

        resource_filename = 'peoplesearch-scripts.tar.gz'

        with sdk2.helpers.ProcessLog(self, logger="tar") as pl:
            sp.check_call(
                "tar -C {folder} -zcf {name} .".format(folder=str(archive_folder), name=resource_filename),
                shell=True, stdout=pl.stdout, stderr=sp.STDOUT
            )

        resource = sdk2.ResourceData(PeoplesearchScripts(self, "Peoplesearch scripts", resource_filename))
        resource.path.write_bytes(sdk2.path.Path(resource_filename).read_bytes())
        resource.ready()
