import logging

from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.common.nanny import nanny
from sandbox.projects.personal_cards.resources import (
    PersonalCardsBinary,

    PersonalCardsConfigProduction,
    PersonalCardsConfigTesting,

    PersonalCardsTvmConfigProduction,
    PersonalCardsTvmConfigTesting,

    PersonalCardsInstancectlConfig,
)


class BuildPersonalCards(YaMakeTemplate.YaMakeTemplate):
    """
        Build personal cards binary.
    """
    class Parameters(YaMakeTemplate.get_project_params(
        build_resources=[
            PersonalCardsBinary
        ],
        source_resources=[
            (resource, resource.arcadia_build_path) for resource in (
                PersonalCardsConfigProduction,
                PersonalCardsConfigTesting,

                PersonalCardsTvmConfigProduction,
                PersonalCardsTvmConfigTesting,

                PersonalCardsInstancectlConfig,
            )
        ],
    )):
        pass

    def on_release(self, parameters_):
        logging.debug("Release parameters: %r", parameters_)
        self._send_release_info_to_email(parameters_)
        self.mark_released_resources(parameters_["release_status"])

        nanny.ReleaseToNannyTask2.on_release(self, parameters_)
