from sandbox import sdk2


class PersonalCardsResourceBase(sdk2.Resource):
    releasable = True
    releasers = [
        "chegoryu",
        "elshiko",

        # Personal cards ci robot and release machine robot
        "robot-prsnl-cards-ci",
        "robot-srch-releaser",
    ]


class PersonalCardsConfigBase(PersonalCardsResourceBase):
    any_arch = True
    executable = False


class PersonalCardsBinary(PersonalCardsResourceBase):
    executable = True
    any_arch = False
    arcadia_build_path = "alice/personal_cards/bin/personal_cards"


class PersonalCardsConfigProduction(PersonalCardsConfigBase):
    arcadia_build_path = "alice/personal_cards/configs/personal_cards_config_production.json"


class PersonalCardsConfigTesting(PersonalCardsConfigBase):
    arcadia_build_path = "alice/personal_cards/configs/personal_cards_config_testing.json"


class PersonalCardsTvmConfigProduction(PersonalCardsConfigBase):
    arcadia_build_path = "alice/personal_cards/configs/tvm_config_production.json"


class PersonalCardsTvmConfigTesting(PersonalCardsConfigBase):
    arcadia_build_path = "alice/personal_cards/configs/tvm_config_testing.json"


class PersonalCardsInstancectlConfig(PersonalCardsConfigBase):
    arcadia_build_path = "alice/personal_cards/configs/instancectl.conf"
