# coding: utf-8

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build import YaPackage

import sandbox.projects.common.build.parameters as build_params


class PlutoPackageParameter(YaPackage.PackagesParameter):
    default_value = ['robot/pluto/packages/pluto_cm.json']


class PlutoResourceTypeParameter(YaPackage.ResourceTypeParameter):
    default_value = 'PLUTO_CM_PACKAGE'


class BuildPlutoPackage(YaPackage.YaPackage, nanny.ReleaseToNannyTask):

    type = 'BUILD_PLUTO_PACKAGE'

    input_parameters = (
        parameters.SandboxArcadiaUrlParameter,
        PlutoPackageParameter,
        PlutoResourceTypeParameter,
        build_params.ArcadiaPatch,
    )

    execution_space = 150 * 1024

    def on_enqueue(self):

        input_parameters_names = set(parameter.name for parameter in self.input_parameters)
        for parameter in YaPackage.YaPackage.input_parameters:
            if parameter.name not in input_parameters_names:
                self.ctx[parameter.name] = parameter().default_value

        self.ctx.update({YaPackage.PackageTypeParameter.name: YaPackage.TARBALL})  # Create tarballs
        self.ctx.update({YaPackage.PublishPackageParameter.name: False})  # Don't publish anything

        YaPackage.YaPackage.on_enqueue(self)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaPackage.YaPackage.on_release(self, additional_parameters)


__Task__ = BuildPlutoPackage
