from sandbox import sdk2


class PlutoniumWorkerBinary(sdk2.Resource):
    """
        Plutonium worker binary package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumWorkerConfigPkg(sdk2.Resource):
    """
        Plutonium worker config package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumGcBinaryPkg(sdk2.Resource):
    """
        Plutonium GC agent binary package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumGcConfigPkg(sdk2.Resource):
    """
        Plutonium GC agent config package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumChunkCtlPackage(sdk2.Resource):
    """
        Chunk-ctl package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumShardCtlPackage(sdk2.Resource):
    """
        Shard-ctl package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True
    sync_upload_to_mds = True


class PlutoniumApiResponderPackage(sdk2.Resource):
    """
        ApiResponder package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True
    sync_upload_to_mds = True


class PlutoniumReplicaCtlPackage(sdk2.Resource):
    """
        Replicactl package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumDeployerBinary(sdk2.Resource):
    """
        Plutonium deployer executable
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumDeployerPackage(sdk2.Resource):
    """
        Plutonium deployer executable + configs
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumCtlConfigsPackage(sdk2.Resource):
    """
        Package built from:
        https://a.yandex-team.ru/arc/trunk/arcadia/search/plutonium/deploy/config/package.json
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumKvrsBinary(sdk2.Resource):
    """
        KVRS executable binary https://a.yandex-team.ru/arc/trunk/arcadia/search/base_search/daemons/kvrs
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumRsProxyBinary(sdk2.Resource):
    """
        RsProxy executable binary https://a.yandex-team.ru/arc/trunk/arcadia/search/base_search/daemons/rs_proxy
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumShootkaPackage(sdk2.Resource):
    """
        Shootka executable binary https://a.yandex-team.ru/arc/trunk/arcadia/search/base_search/daemons/rs_proxy
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumCoordinatorPackage(sdk2.Resource):
    """
        Coordinator package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumSnapshotReplicatorPkg(sdk2.Resource):
    """
        Snapshot replicator package (executable + configs)
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumValidatorPkg(sdk2.Resource):
    """
        Validator package (executable + configs)
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumValidatorHooksPkg(sdk2.Resource):
    """
        Validator hooks package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class PlutoniumInstanceSyncerPackage(sdk2.Resource):
    """
        Standalone instance syncer package
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class Saas2AdminIndexConfigPackage(sdk2.Resource):
    """
        Admin index config  https://a.yandex-team.ru/arc/trunk/arcadia/search/plutonium/admin/index/config/package.json
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class Saas2AdminConfigYabsPackage(sdk2.Resource):
    """
        Saas 2 Admin yabs configs  https://a.yandex-team.ru/arc/trunk/arcadia/search/plutonium/admin/configs/yabs/package.json
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class Saas2AdminWebAppBin(sdk2.Resource):
    """
        Saas 2 Admin web app binary  https://a.yandex-team.ru/arc/trunk/arcadia/search/plutonium/admin/web
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True


class Saas2AdminDaemonBin(sdk2.Resource):
    """
        Saas 2 Admin daemon binary  https://a.yandex-team.ru/arc/trunk/arcadia/search/plutonium/admin/deamon
    """
    releasable = True
    releasers = ['robot-saas2-worker']
    auto_backup = True
