import functools as ft

from sandbox import sdk2


def resource_types_with_prefixes(*args):
    return [
        r.name
        for r in sdk2.Resource if any(
            r.name.startswith(arg)
            for arg in args
        )
    ]


porto_layer_types = ft.partial(resource_types_with_prefixes, "PORTO_LAYER")
porto_image_types = ft.partial(resource_types_with_prefixes, "PORTO_IMAGE", "PORTO_SQUASH", "QEMU_IMAGE")
