# coding: utf-8

from sandbox import sdk2

import sandbox.projects.resource_types.releasers as resource_releasers
from sandbox.projects.search_velocity.resources import releasers as velocity_releasers


# GENERIC -----------------------------


class PORTO_LAYER(sdk2.service_resources.BasePortoLayer):
    """
    Abstract porto layer
    """

    auto_backup = False
    releasable = True
    releasers = ["khlebnikov", "sivanichkin", "noiseless", "warwish", "nekto0n"]


class PORTO_SQUASH(sdk2.Resource):
    """
    Porto squashfs image
    """

    releasable = True
    releasers = ["khlebnikov"]


class PORTO_LAYER_BOOTSTRAP(sdk2.Resource):
    """
    Bootstrap porto layer
    """

    releasable = True
    releasers = ["khlebnikov"]


# COMMON RUNTIME CLOUD ----------------


class PORTO_LAYER_RTC(sdk2.Resource):
    """
    Abstract RTC Porto layer
    """

    auto_backup = True
    releasable = True
    releasers = ["sivanichkin", "noiseless", "warwish", "nekto0n", "evgenyemets", "zeebdo"]


class PORTO_SQUASH_RTC(sdk2.Resource):
    """
    Abstract RTC Porto squashfs image
    """

    auto_backup = True
    releasable = True
    releasers = ["sivanichkin", "noiseless", "warwish", "nekto0n"]


class PORTO_LAYER_SEARCH_UBUNTU_FOCAL_APP(PORTO_LAYER_RTC):
    """
    RTC Porto layer with Ubuntu Focal Fossa (20.04)
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_FOCAL_QEMU(PORTO_LAYER_RTC):
    """
    RTC vm layer with Ubuntu Focal Fossa (20.04)
    """
    pass


class QEMU_IMAGE_RTC_UBUNTU_FOCAL(PORTO_LAYER_SEARCH_UBUNTU_FOCAL_QEMU):
    """
    RTC QYP image with Ubuntu Focal Fossa (20.04)
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_FOCAL_DEVEL_QEMU(PORTO_LAYER_RTC):
    """
    RTC dev vm layer with Ubuntu Focal Fossa (20.04)
    """
    pass


class QEMU_IMAGE_RTC_UBUNTU_FOCAL_DEVEL(PORTO_LAYER_SEARCH_UBUNTU_FOCAL_DEVEL_QEMU):
    """
    RTC QYP dev image with Ubuntu Focal Fossa (20.04)
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_FOCAL_QEMU_GPU(PORTO_LAYER_RTC):
    """
    RTC vm layer with Ubuntu Focal Fossa (20.04) and GPU support
    """
    pass


class QEMU_IMAGE_RTC_UBUNTU_FOCAL_GPU(PORTO_LAYER_SEARCH_UBUNTU_FOCAL_QEMU_GPU):
    """
    RTC QYP image with Ubuntu Focal Fossa (20.04) and GPU support
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_BIONIC(PORTO_LAYER_RTC):
    """
    RTC Porto layer with Ubuntu Bionic (systemd)
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_XENIAL_SYSTEMD(PORTO_LAYER_RTC):
    """
    RTC Porto layer with Ubuntu Xenial (systemd)
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_XENIAL(PORTO_LAYER_RTC):
    """
    RTC Porto layer with Ubuntu Xenial (upstart)
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_TRUSTY(PORTO_LAYER_RTC):
    """
    (DEPRECATED) RTC Porto layer with Ubuntu Trusty (upstart)
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_PRECISE(PORTO_LAYER_RTC):
    """
    (DEPRECATED) RTC Porto layer with Ubuntu Precise (upstart)
    """
    pass


# BASE APPLICATION LAYERS for RUNTIME CLOUD --------


class PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu bionic
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_XENIAL_APP(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu xenial
    """
    pass


class PORTO_SQUASH_SEARCH_UBUNTU_XENIAL_APP(PORTO_SQUASH_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu xenial (squashfs)
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_TRUSTY_APP(PORTO_LAYER_RTC):
    """
    (DEPRECATED) Базовый поисковый образ porto контейнера ubuntu trusty
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_PRECISE_APP(PORTO_LAYER_RTC):
    """
    (DEPRECATED) Базовый поисковый образ porto контейнера ubuntu precise
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_BIONIC_QEMU(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu bionic
    """
    pass


class QEMU_IMAGE_RTC_UBUNTU_BIONIC(PORTO_LAYER_SEARCH_UBUNTU_BIONIC_QEMU):
    """
    QYP bionic image
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_XENIAL_QEMU(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu xenial
    """
    pass


class QEMU_IMAGE_RTC_UBUNTU_XENIAL(PORTO_LAYER_SEARCH_UBUNTU_XENIAL_QEMU):
    """
    QYP image xenial
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_XENIAL_SYSTEMD_QEMU(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu xenial
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_TRUSTY_QEMU(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu trusty
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_PRECISE_QEMU(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu precise
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_BIONIC_SUBAGENT(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu bionic
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_XENIAL_SUBAGENT(PORTO_LAYER_RTC):
    """
    Базовый поисковый образ porto контейнера ubuntu xenial
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_TRUSTY_SUBAGENT(PORTO_LAYER_RTC):
    """
    (DEPRECATED) Базовый поисковый образ porto контейнера ubuntu trusty
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_PRECISE_SUBAGENT(PORTO_LAYER_RTC):
    """
    (DEPRECATED) Базовый поисковый образ porto контейнера ubuntu precise
    """
    pass


# LEGACY RUNTIME CLOUD ----------------


class PORTO_LAYER_SEARCH_UBUNTU_LUCID(PORTO_LAYER_RTC):
    """
    (DEPRECATED) RTC Porto layer with Ubuntu Lucid
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_LUCID_APP(PORTO_LAYER_RTC):
    """
    (DEPRECATED) Базовый поисковый образ porto контейнера ubuntu lucid
    """
    pass


class PORTOVM_LAUNCHER(sdk2.Resource):
    """
    (DEPRECATED) launcher for portovm
    """

    releasable = True
    auto_backup = True
    releasers = ["sivanichkin", "noiseless"]


class PORTOVM_LAUNCHER_MTN(sdk2.Resource):
    """
    (DEPRECATED) launcher_mtn for portovm
    """

    releasable = True
    releasers = ["sivanichkin", "noiseless"]


class PORTO_LAYER_SKYNET(sdk2.Resource):
    """
    Базовый образ skynet для porto контейнера
    """
    releasable = True
    releasers = ['oplachkin', 'mocksoul', 'torkve']


# QEMU RUNTIME CLOUD ------------------


class PORTO_LAYER_SEARCH_QEMU_UBUNTU_XENIAL(sdk2.Resource):
    """
    RTC QEMU agent/launcher
    https://wiki.yandex-team.ru/runtime-cloud/qemu-kvm/release/
    """

    releasable = True
    releasers = ["frolstas", "max7255", "sivanichkin", "noiseless"]


class QEMU_IMAGE_RTC(sdk2.Resource):
    """
    Abstract RTC QEMU image
    """

    releasable = True
    releasers = ["max7255", "sivanichkin", "noiseless", "warwish", "evgenyemets", "zeebdo"]


class QEMU_IMAGE_SEARCH_PRECISE(QEMU_IMAGE_RTC):
    """
    (DEPRECATED) Search-Precise based qemu images, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_PRECISE_DEVEL(QEMU_IMAGE_RTC):
    """
    (DEPRECATED) Search-Precise based qemu images, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_TRUSTY(QEMU_IMAGE_RTC):
    """
    (DEPRECATED) Search-Trusty based qemu images, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_TRUSTY_DEVEL(QEMU_IMAGE_RTC):
    """
    (DEPRECATED) Search-Trusty based qemu images, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_XENIAL(QEMU_IMAGE_RTC):
    """
    Search-Xenial based qemu images, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_XENIAL_SYSTEMD(QEMU_IMAGE_RTC):
    """
    Search-Xenial based qemu images, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_XENIAL_SYSTEMD_DEVEL(QEMU_IMAGE_RTC):
    """
    Search-Xenial based qemu images, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_XENIAL_DEVEL(QEMU_IMAGE_RTC):
    """
    Search-Xenial based qemu images, built with BuildPortoLayer
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_XENIAL_DEVEL_QEMU(PORTO_LAYER_RTC):
    """
    RTC dev vm layer with Ubuntu Xenial
    """
    pass


class QEMU_IMAGE_RTC_UBUNTU_XENIAL_DEVEL(PORTO_LAYER_SEARCH_UBUNTU_XENIAL_DEVEL_QEMU):
    """
    RTC QYP dev image with Ubuntu Xenial
    """
    pass


class QEMU_IMAGE_SEARCH_XENIAL_GPU_DEVEL(QEMU_IMAGE_RTC):
    """
    Search-Xenial based qemu images with nvidia drivers, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_BIONIC(QEMU_IMAGE_RTC):
    """
    Search-Bionic based qemu images, built with BuildPortoLayer
    """
    pass


class PORTO_LAYER_SEARCH_UBUNTU_BIONIC_DEVEL_QEMU(PORTO_LAYER_RTC):
    """
    RTC dev vm layer with Ubuntu Bionic
    """
    pass


class QEMU_IMAGE_RTC_UBUNTU_BIONIC_DEVEL(PORTO_LAYER_SEARCH_UBUNTU_BIONIC_DEVEL_QEMU):
    """
    RTC QYP dev image with Ubuntu Bionic
    """
    pass


class QEMU_IMAGE_SEARCH_BIONIC_DEVEL(QEMU_IMAGE_RTC):
    """
    Search-Bionic based qemu images, built with BuildPortoLayer
    """
    pass


class QEMU_IMAGE_SEARCH_BIONIC_GPU_DEVEL(QEMU_IMAGE_RTC):
    """
    Search-Bionic based qemu images with nvidia drivers, built with BuildPortoLayer
    """
    pass


# PORTO ML LAYER types
# for testing using OS-specific resource types
class PORTO_LAYER_RTC_NVIDIA_450_XENIAL_DIFF(PORTO_LAYER_SEARCH_UBUNTU_XENIAL_APP):
    """
    diff-layer with actual 450-branch nvidia drivers
    """
    pass


class PORTO_LAYER_RTC_CUDA_10_1_XENIAL_DIFF(PORTO_LAYER_RTC_NVIDIA_450_XENIAL_DIFF):
    """
    diff-layer with cuda-10.1
    """
    pass


# PORTO DEV ---------------------------


class QEMU_IMAGE_PORTO_TESTING(sdk2.Resource):
    """
    qemu images for porto testing
    """
    releasable = True
    releasers = ['khlebnikov', 'max7255']


# MISC --------------------------------


class PORTO_LAYER_JUGGLERCLI(sdk2.Resource):
    """
    Porto container for Juggler CLI hosts
    """

    releasable = True
    releasers = ["basic"]


class PORTO_IMAGE_ADDRS_BASE(sdk2.Resource):
    """
    Porto container for ADDRS with some basic daemons (geocoder wikicoder transport)
    """

    releasable = True
    releasers = resource_releasers.geosearch_releasers + resource_releasers.geosearch_admins


class PORTO_IMAGE_ADDRS_GEO(sdk2.Resource):
    """
    Porto container for ADDRS with some basic daemons (business wiki)
    """

    releasable = True
    releasers = resource_releasers.geosearch_releasers + resource_releasers.geosearch_admins


class PORTO_IMAGE_ADDRS_GEODAEMON(sdk2.Resource):
    """
    Porto container for ADDRS with geodaemon
    """

    releasable = True
    releasers = resource_releasers.geosearch_releasers + resource_releasers.geosearch_admins


class PORTO_IMAGE_ADDRS_QAAS(sdk2.Resource):
    """
    Porto container for ADDRS with qaas
    """

    releasable = True
    releasers = resource_releasers.geosearch_releasers + resource_releasers.geosearch_admins


class PORTO_IMAGE_ADDRS_SAAS_BASE(sdk2.Resource):
    """
    Porto container for ADDRS with geortyserver
    """

    releasable = True
    releasers = resource_releasers.geosearch_releasers + resource_releasers.geosearch_admins


class PORTO_IMAGE_ADDRS_TRANSIT(sdk2.Resource):
    """
    Porto container for ADDRS with basic route search
    """

    releasable = True
    releasers = resource_releasers.geosearch_releasers + resource_releasers.geosearch_admins


class PORTO_IMAGE_ADDRS_ADVERT(sdk2.Resource):
    """
    Porto container for ADDRS with advert search
    """

    releasable = True
    releasers = resource_releasers.geosearch_releasers + resource_releasers.geosearch_admins


class PORTO_IMAGE_BOTANIK(sdk2.Resource):
    """
    Porto container for Botanik
    """

    releasable = True
    releasers = ["sivanichkin", "reddog"]


class PORTO_IMAGE_C1(sdk2.Resource):
    """
    Porto container for C1
    """

    releasable = True
    releasers = ["mcden", "sivanichkin"]


class PORTO_IMAGE_CLUSTERAPI(sdk2.Resource):
    """
    Porto container for CLUSTERAPI
    """

    releasable = True
    releasers = ["sivanichkin"]


class PORTO_IMAGE_COCAINE(sdk2.Resource):
    """
    Porto image with cocaine for ClusterAPI/ISS
    """

    releasable = True
    auto_backup = True
    releasers = ["kdmitriy", "noxiouz", "linux0id", "broom", "borislitv", "esafronov", "antmat"]


class PORTO_IMAGE_GEOADMIN(sdk2.Resource):
    """
    Porto container for Geoadmin
    """

    releasable = True
    releasers = ["sivanichkin", "reddog", "karas-pv"]


class PORTO_IMAGE_GEOEXPORT(sdk2.Resource):
    """
    Porto container for Geoexport
    """

    releasable = True
    releasers = ["karas-pv", "dieash"]


class PORTO_IMAGE_KIWICALC(sdk2.Resource):
    """
    Porto container for KiwiCalc
    """

    releasable = True
    releasers = ["sivanichkin"]


class PORTO_IMAGE_LINGVO(sdk2.Resource):
    """
    Porto container for LINGVO
    """

    releasable = True
    releasers = ["bykanov", "sivanichkin"]


class PORTO_IMAGE_MAPS(sdk2.Resource):
    """
    Porto container for MAPS
    """

    releasable = True
    releasers = ["siur"]


class PORTO_IMAGE_MEDIAPORTRAITS(sdk2.Resource):
    """
    Porto container for MEDIAPORTRAITS
    """

    releasable = True
    releasers = ["sivanichkin"]


class PORTO_IMAGE_MYSQL(sdk2.Resource):
    """
    Porto container for MYSQL
    """

    releasable = True
    releasers = ["marchhare", "bykanov"]


class PORTO_IMAGE_PERSONALSUGGEST(sdk2.Resource):
    """
    Porto container for LINGVO
    """

    releasable = True
    releasers = ["bykanov", "sivanichkin", "vsavenkov"]


class PORTO_IMAGE_QLOUD_ROUTER(sdk2.Resource):
    """
    Porto container for Qloud router
    """

    auto_backup = True
    releasable = True
    releasers = ["xgen", "bgleb", "lvovich", "terry", "kozhapenko"]


class PORTO_IMAGE_QLOUD_AUTH_TVM(sdk2.Resource):
    """
    Porto container for Qloud auth with tvm ticket parser
    """

    auto_backup = True
    releasable = True
    releasers = ["panefgen"]


class PORTO_IMAGE_ROBOT_TEST(sdk2.Resource):
    """
    Porto container for robot admins' dirty experiments
    """

    auto_backup = True
    releasable = True
    releasers = ["sivanichkin", "mkulemin"]


class PORTO_IMAGE_SAMOGON(sdk2.Resource):
    """
    Porto container for Samogon
    """

    releasable = True
    releasers = ["maxuta"]


class PORTO_IMAGE_SEEK(sdk2.Resource):
    """
    Porto container for SEEK
    """

    releasable = True
    releasers = ["sivanichkin", "artanis", "alexashin"]


class PORTO_IMAGE_UNITSCONVERTER(sdk2.Resource):
    """
    Porto container for LINGVO
    """

    releasable = True
    releasers = ["bykanov", "sivanichkin", "vsavenkov"]


class PORTO_LAYER_UNITSCONVERTER(sdk2.Resource):
    """
    Porto layer for units-converter
    """

    releasable = True
    releasers = resource_releasers.suggest_releasers


class PORTO_IMAGE_YABS_ML_ENGINE(sdk2.Resource):
    """
    Porto container for yabs-ml-engine
    """

    auto_backup = True
    releasable = True
    releasers = ["amitin", "mstebelev"]


class PORTO_IMAGE_YTCALC(sdk2.Resource):
    """
    Porto container for YTCalc
    """

    releasable = True
    releasers = ["sivanichkin"]


class PORTO_LAYER_ADDRS_SAAS_BASE(sdk2.Resource):
    """
    Porto layer for ADDRS with geortyserver
    """

    releasable = True
    releasers = resource_releasers.geosearch_releasers + resource_releasers.geosearch_admins


class PORTO_LAYER_BALANCER_MEDIA(sdk2.Resource):
    """
    Porto layer for media search balancers from RuntimeCloud for use with common network namespace
    """

    releasable = True
    releasers = resource_releasers.media_sre
    release_subscribers = resource_releasers.media_sre


class PORTO_LAYER_C1(sdk2.Resource):
    """
    Porto layer for C1
    """

    releasable = True
    releasers = ["mcden", "sivanichkin"]


class PORTO_LAYER_CLICKHOUSE_TEMPLATE(sdk2.Resource):
    """
    Porto layer with ClickHouse template
    """

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["reddog", "cepera"]


class PORTO_LAYER_COCAINE(sdk2.Resource):
    """
    Porto layer with cocaine for porto/docker
    """

    releasable = True
    auto_backup = True
    releasers = ["kdmitriy", "noxiouz", "linux0id", "broom", "borislitv", "esafronov", "antmat"]


class PORTO_LAYER_COLLECTIONS_BACKEND(sdk2.Resource):
    """
    Porto layer for collections backend
    """

    releasable = True
    releasers = resource_releasers.collections_releasers


class PORTO_LAYER_CORONER(sdk2.Resource):
    """
    Porto layer for coroner
    """

    releasable = True
    releasers = ["sivanichkin", "khlebnikov"]


class PORTO_LAYER_GEOBASE_PRECISE(sdk2.Resource):
    """
    Porto layer with 12.04 for geobase-related projects
    """

    releasable = True
    releasers = ['dieash', 'dude', 'karas-pv', 'robot-geobase']


class PORTO_LAYER_GEOBASE_TRUSTY(sdk2.Resource):
    """
    Porto layer with 14.04 for geobase-related projects (geoexport)
    """

    releasable = True
    releasers = ['dieash', 'dude', 'karas-pv', 'robot-geobase']


class PORTO_LAYER_EXPADM(sdk2.Resource):
    """
    Porto layer for Experiments admin panel
    """

    auto_backup = True
    releasable = True
    releasers = resource_releasers.experiment_releasers


class PORTO_LAYER_FINDURL(sdk2.Resource):
    """
    Porto layer for FindUrl at Nanny
    """

    releasable = True
    releasers = resource_releasers.base_releasers + resource_releasers.middle_releasers


class PORTO_LAYER_INFRASEARCH_CHECKER(sdk2.Resource):
    """
    Resource with pkg yandex-search-infrasearch-checker for porto
    """

    releasable = True
    releasers = ["sivanichkin"]


class PORTO_LAYER_LUNAPARK_CLICKHOUSE(sdk2.Resource):
    """
    Porto layer for LUNAPARK_CLICKHOUSE
    """

    releasable = True
    releasers = ["ligreen", "r2d2", "direvius", "noob"]


class PORTO_LAYER_LUNAPARK_FRONT(sdk2.Resource):
    """
    Porto layer for LUNAPARK_FRONT
    """

    releasable = True
    releasers = ["ligreen", "r2d2", "direvius", "noob"]


class PORTO_LAYER_LUNAPARK_WRITER(sdk2.Resource):
    """
    Porto layer for LUNAPARK_WRITER
    """

    releasable = True
    releasers = ["ligreen", "r2d2", "direvius", "noob"]


class PORTO_LAYER_MARKET_BASE(sdk2.Resource):
    """
    Base Porto layer for Market
    """

    releasable = True
    releasers = ["strkate", "dukeartem", "d3rp", "maxk", "le078", "kemsta", "idonin", "adubrovin", "slyder", "asimakov"]


class PORTO_LAYER_METRIKA_BASE_TRUSTY(sdk2.Resource):
    """
    Base Porto layer for Metrika (trusty)
    """

    releasable = True
    releasers = ["velom", "frenz", "presto", "robert"]


class PORTO_LAYER_NEWS(sdk2.Resource):
    """
    News porto layer (currently for testing)
    """

    releasable = True
    releasers = ["sgrb"]


class PORTO_LAYER_PPC_COMMON(sdk2.Resource):
    """
    Base Porto layer for Direct
    """

    releasable = True
    releasers = resource_releasers.direct_sre


class PORTO_LAYER_PPC_COMMON_PRECISE(sdk2.Resource):
    """
    Base Porto layer for Direct (precise)
    """

    releasable = True
    releasers = resource_releasers.direct_sre


class PORTO_LAYER_PPC_COMMON_TRUSTY(sdk2.Resource):
    """
    Base Porto layer for Direct (trusty)
    """

    releasable = True
    releasers = resource_releasers.direct_sre


class PORTO_LAYER_AGENCY_FRONTEND(sdk2.Resource):
    """
    Frontend Porto layer for Agency (precise)
    """
    releasable = True
    releasers = resource_releasers.direct_sre


class PORTO_LAYER_AGENCY_BACKEND(sdk2.Resource):
    """
    Backend Porto layer for Agency (precise)
    """
    releasable = True
    releasers = resource_releasers.direct_sre


class PORTO_LAYER_PSI(sdk2.Resource):
    """
    Porto layer for psi
    """

    releasable = True
    auto_backup = True
    releasers = ["cerg1168", "okats", "stunder", "knuzhdin", "dcherednik", "andozer", "mcden"]
    ttl = 90


class PORTO_LAYER_QEMUVM(sdk2.Resource):
    """
    Porto layer for sitesearch with qemu binary & qemu launcher
    """

    releasable = True
    releasers = ["sivanichkin", "noiseless", "max7255"]


class PORTO_LAYER_RT_RESEARCH(sdk2.Resource):
    """
    Base Porto laye for rt-research (Advertising Technologies Research)
    """

    releasable = True
    releasers = ["rivik", "dspushkin", "pe4kin", "yukaba", "sco76", "lena-san"]


class PORTO_LAYER_SEARCH_UBUNTU_64NET(sdk2.Resource):
    """
    Base Search Porto layer
    """

    releasable = True
    releasers = ["sivanichkin", "noiseless"]


class PORTO_LAYER_SERVICE_PROBLEMS(sdk2.Resource):
    """
    resource with image for porto
    """

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["basic", "ekilimchuk"]


class PORTO_LAYER_SITESEARCH(sdk2.Resource):
    """
    Porto layer for sitesearch with tvm parser
    """

    releasable = True
    releasers = ["lester", "avhaliullin", "aleksart"]


class PORTO_LAYER_SOLOVKI(sdk2.Resource):
    """
    Porto layer for Juggler
    """

    releasable = True
    releasers = ["sivanichkin"]


class PORTO_LAYER_SUGGEST_PERSONAL(sdk2.Resource):
    """
    Base Porto layer for personal suggest daemon
    """

    releasable = True
    releasers = resource_releasers.suggest_releasers


class PORTO_LAYER_TYCOON(sdk2.Resource):
    """
    Porto layer for Tycoon
    """

    releasable = True
    releasers = resource_releasers.tycoon


class PORTO_LAYER_TRENCHER(sdk2.Resource):
    """
    Porto layer for Trencher
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = velocity_releasers


class PORTO_LAYER_WMCONSOLE_BATCH(sdk2.Resource):
    """
    Porto layer for batch processes in Webmaster
    """

    releasable = True
    releasers = ["lester", "avhaliullin"]


class PORTO_LAYER_YABS_AUTOBUDGET(sdk2.service_resources.BasePortoLayer):
    """
    Porto layer for YABS Autobudget
    """

    auto_backup = True
    releasable = True
    releasers = ["YABS_AUTOBUDDGET"]


class PORTO_LAYER_YADNS(sdk2.Resource):
    """
    resource with image for porto
    """

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["reddog", "ekilimchuk"]


class PORTO_LAYER_YANDEX_TANK(sdk2.Resource):
    """
    Porto layer for YANDEX_TANK
    """

    releasable = True
    releasers = ["ligreen", "r2d2", "direvius"]


class PORTO_LAYER_DEV_BUILD_INFRA(sdk2.Resource):
    """
    Porto layer for infra containders
    """

    releasable = True
    releasers = ["sivanichkin"]


class PORTO_LAYER_VOLTA_CLICKHOUSE(sdk2.Resource):
    """
    Porto layer for VOLTA_CLICKHOUSE
    """

    releasable = True
    releasers = ["ligreen", "r2d2", "direvius", "noob"]


class PORTO_LAYER_OVERLOAD_CLICKHOUSE(sdk2.Resource):
    """
    Porto layer for VOLTA_CLICKHOUSE
    """

    releasable = True
    releasers = ["ligreen", "r2d2", "direvius", "noob"]


class PORTO_LAYER_OVERLOAD_FRONT(sdk2.Resource):
    """
    Porto layer for VOLTA_FRONT
    """

    releasable = True
    releasers = ["ligreen", "r2d2", "direvius", "noob"]


class PORTO_LAYER_YT(sdk2.Resource):
    """
    Porto container for YT
    """

    releasable = True
    releasers = ["YT_ROBOT"]


class PORTO_LAYER_YT_STATBOX(sdk2.Resource):
    """
    Porto container for Statboxed YT tasks
    """

    releasable = True
    releasers = ['hans', 'dmifedorov', 'shprot', 'thenno']


class PORTO_LAYER_SO_BASE(sdk2.Resource):
    """
    Porto container for SO: base layer
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_YP(sdk2.Resource):
    """
    Porto container for SO: layer with YP CLI packages
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_DB(sdk2.Resource):
    """
    Porto container for SO: layer with DB packages
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_ML_WEB(sdk2.Resource):
    """
    Porto container for SO: ML & Web packages
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_BUILD_TOOLS(sdk2.Resource):
    """
    Porto container for SO: build tools
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_LOCAL_SERVERS(sdk2.Resource):
    """
    Porto container for SO: local servers such as nginx, redis and so on
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_RBLDNSD(sdk2.Resource):
    """
    Porto container for SO: layer with rbldnsd daemon's package
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_CHROMIUM(sdk2.Resource):
    """
    Porto container for SO: layer with chromium
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_FIREFOX(sdk2.Resource):
    """
    Porto container for SO: layer with firefox
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_SO_CURL(sdk2.Resource):
    """
    Porto container for SO: libcurl4 & libcurl4-openssl-dev packages
    """

    releasable = True
    releasers = ["robot-mailspam", "klimiky", "luckybug", "dpotapov"]
    ttl = 365


class PORTO_LAYER_IMAGES_GUPPY_CUDA(sdk2.Resource):
    """
    Porto layer with CUDA for GUPPY project
    """

    releasable = True
    releasers = resource_releasers.images_robot_releasers


class PORTO_LAYER_KWYT_CM(sdk2.Resource):
    """
        Слой porto контейнера ubuntu xenial для KwYT Cluster Master
    """

    releasable = True
    releasers = ["lexeyo", "zagevalo", "shuster"]


class PORTO_LAYER_JANNA(sdk2.Resource):
    """
    Porto layer for Janna
    """

    releasable = True
    releasers = resource_releasers.tycoon


class PORTO_LAYER_PERSONAL_SEARCH(sdk2.Resource):
    """
    Porto layer for personal search
    """

    auto_backup = True
    releasable = True
    releasers = ["dpotapov", "m-smolina", "okkk", "tabolin", "vonidu", "klimiky"]


class PORTO_LAYER_PERSONAL_SEARCH_NGINX(PORTO_LAYER_PERSONAL_SEARCH):
    """
    Porto layer for personal search with nginx
    """

    pass


class PORTO_LAYER_PERSONAL_SEARCH_DJANGO(PORTO_LAYER_PERSONAL_SEARCH):
    """
    Porto layer for personal search with django
    """

    pass


class PORTO_LAYER_PERSONAL_SEARCH_MSAL(PORTO_LAYER_PERSONAL_SEARCH):
    """
    Porto layer for personal search for msal
    """

    pass


class PORTO_LAYER_SUPERDUPS(sdk2.Resource):
    """
        Слой porto контейнера ubuntu xenial для SuperDups
    """

    releasable = True
    releasers = ["izetag", "lexeyo", "shuster", "zagevalo", "zhenyok", "akhruslan", "dimmia"]


class PORTO_LAYER_SDC_YARG(sdk2.Resource):
    """
        Porto layer for yarg from selfdriving project
    """

    releasable = True
    releasers = ["marchhare", "kmeaw", "antrue", "astsmtl", "gerasiov"]


class PORTO_LAYER_SDC_NIRVANA(sdk2.Resource):
    """
        Proto layer to in nirvana jobs for selfdriving
    """

    releasable = True
    releasers = ["marchhare", "riddle", "akaluzhin"]


class PORTO_LAYER_TRACKER_RTC_RELEASE(sdk2.Resource):
    """
        Porto layer for releases of Yandex Tracker RTC components
    """

    releasable = True
    releasers = ["dm-tim", "lotrek", "aite", "zamysh", "amilynn", "ctash", "kuptservol", "rolenof"]
    release_subscribers = ["dm-tim", "lotrek", "aite", "zamysh", "amilynn", "ctash", "kuptservol", "rolenof"]
    auto_backup = True
    ttl = 999


class PORTO_LAYER_DIST(sdk2.Resource):
    """
    Porto layer for DIST project
    """

    releasable = True
    releasers = ["sivanichkin", "mikesenin", "evgenyemets", "zeebdo", "warwish", "noiseless"]


class PORTO_LAYER_DIST_MONGO(PORTO_LAYER_DIST):
    """
    Porto layer for DIST project
    """
    pass


class PORTO_LAYER_DIST_ZOOKEEPER(PORTO_LAYER_DIST):
    """
    Porto layer for DIST project
    """
    pass


class PORTO_LAYER_IMAGES_ROBOT(sdk2.Resource):
    """
    Porto layer for images robot project
    """

    releasable = True
    releasers = resource_releasers.images_robot_releasers


class PORTO_LAYER_IMAGES_DUCK_CM(sdk2.Resource):
    """
    Porto layer for images-duck project
    """

    releasable = True
    releasers = resource_releasers.images_duck_releasers


class PORTO_LAYER_BROWSER_ANALYTICS(sdk2.Resource):
    """
    Porto layer for browser analytics calculations
    """

    releasable = True
    releasers = ['baza', 'luchnich', 'vlaklimov', 'aogay']


class PORTO_LAYER_US_KPI_ROBOT(sdk2.service_resources.BasePortoLayer):
    """
    Porto layer for https://deploy.yandex-team.ru/stages/kpi-robot/deploy-tickets
    """

    auto_backup = False
    releasable = True
    releasers = resource_releasers.user_sessions_releasers
