# -*- coding: utf-8 -*-

import os

from sandbox.projects.prs_ops import resources as resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects import resource_types as global_resource_types
import sandbox.projects.common.constants as consts
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.configs.prs_ops import PrsOpsCfg
from sandbox.projects.release_machine import rm_notify as rm_notify
from sandbox.projects.common.sdk_compat import task_helper


@rm_notify.notify2()
class BuildPrsOps(YaMakeTask):

    execution_space = 80 * 1024

    type = 'BUILD_PRS_OPS'

    TARGET_RESOURCE_TYPES = [
        resource_types.PRS_OPS_EXECUTABLE,
        global_resource_types.PROTO_POOL_READER_EXECUTABLE,
        global_resource_types.POOL_CONVERTER_EXECUTABLE,
        resource_types.PRS_OPS_FACTOR_DIFF,
    ]

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.Sanitize,
        build_params.CheckoutParameter,
    ] + build_params.get_aapi_parameters_as_default()

    def get_targets(self):
        return [resource_type.arcadia_build_path
                for resource_type in self.TARGET_RESOURCE_TYPES]

    def on_enqueue(self):
        if '/trunk/' in self.ctx[consts.ARCADIA_URL_KEY]:
            self.execution_space = 45 * 1024  # should dramatically decrease time spent in the queue
        task_helper.ctx_field_set(self, rm_const.COMPONENT_CTX_KEY, PrsOpsCfg.name)
        YaMakeTask.on_enqueue(self)

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource

        return resources

    def get_arts(self):
        return [{'path': resource_type.arcadia_build_path} for resource_type in self.TARGET_RESOURCE_TYPES]


__Task__ = BuildPrsOps
