import itertools
import os
import shutil

from sandbox import sdk2

from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.common import file_utils as fu
from sandbox.projects.prs_ops import resources as resource_types
from sandbox.projects.common.search import bugbanner2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.configs.prs_ops import PrsOpsCfg
from sandbox.projects.release_machine import rm_notify as rm_notify
from sandbox.projects.common.sdk_compat import task_helper


@rm_notify.notify2()
class CompareYtTablesPrsOps(bugbanner2.BugBannerTask):

    class Requirements(sdk2.Task.Requirements):
        ram = 40 * 1024
        disk_space = 5 * 1024

        environments = [
            PipEnvironment('yandex-yt', version="0.8.29.post0", use_wheel=True),
            PipEnvironment('yandex-yt-yson-bindings-skynet', version="0.3.7.post1", use_wheel=True)
        ]

    class Parameters(sdk2.Task.Parameters):
        path_1 = sdk2.parameters.String("First id (dir in //home/prs_ops/)")
        path_2 = sdk2.parameters.String("Second id (dir in //home/prs_ops/)")
        check_diff = sdk2.parameters.Resource(
            "check_diff executable",
            # resourse_type=resource_types.PRS_OPS_FACTOR_DIFF,  # FIXME: invalid argument (SANDBOX-6404)
        )

    def on_enqueue(self):
        task_helper.ctx_field_set(self, rm_const.COMPONENT_CTX_KEY, PrsOpsCfg.name)

    def on_execute(self):

        self.add_bugbanner(bugbanner2.Banners.PrsOps)

        self.Context.has_diff = False

        if "casting" in self.Parameters.path_1:
            SAME_TABLES = ["factor_slices", ]
            SAME_NUM_LINES = []
        else:
            SAME_TABLES = ["factor_slices", "queries", "qids", "ratings"]
            SAME_NUM_LINES = ["requests", "stats"]

        diff_resource = resource_types.PRS_OPS_DIFF(
            self,
            "diff",
            "diff.txt")
        diff_resource_data = sdk2.ResourceData(diff_resource)

        token = sdk2.Vault.data('prs_ops_yt_test')
        from yt.wrapper import YtClient
        yt_client = YtClient('hahn', token)
        os.environ["YT_PREFIX"] = "/"
        os.environ["YT_TOKEN"] = sdk2.Vault.data("prs_ops_yt_test")
        tables_1 = "//home/prs_ops/{}".format(self.Parameters.path_1)
        tables_2 = "//home/prs_ops/{}".format(self.Parameters.path_2)
        for table in SAME_TABLES:
            table_1 = yt_client.read_table(tables_1 + "/" + table)
            table_2 = yt_client.read_table(tables_2 + "/" + table)
            if table == "ratings":
                flag = any([val1 != val2 for val1, val2 in itertools.izip(sorted(table_1), sorted(table_2))])
            else:
                flag = any([val1 != val2 for val1, val2 in itertools.izip(table_1, table_2)])
            if flag:
                if table == "factor_slices":
                    self.diff_create(
                        "{} are different\n "
                        "Table1: {}\n "
                        "Factor_slices_1 "
                        "content: {}\n "
                        "Table2: {}\n "
                        "Factor_slices_2 content: {}\n".format(
                            table,
                            tables_1 + "/" + table,
                            "\n".join([str(i) for i in yt_client.read_table(tables_1 + "/" + table)]),
                            tables_2 + "/" + table,
                            "\n".join([str(i) for i in yt_client.read_table(tables_2 + "/" + table)]),
                        ),
                        diff_resource_data
                    )
                    return
                else:
                    self.diff_create("{} are different\n Table1: {}\n Table2: {}".format(
                        table,
                        tables_1 + "/" + table,
                        tables_2 + "/" + table,
                    ), diff_resource_data)
                    return
        if "casting" in self.Parameters.path_1:
            table_1 = yt_client.read_table(tables_1 + "/qids")
            table_2 = yt_client.read_table(tables_2 + "/qids")
            if any([val1 != val2 for val1, val2 in itertools.izip(
                    sorted(table_1, key=lambda x: int(x["key"])),
                    sorted(table_2, key=lambda x: int(x["key"])),
            )]):
                self.diff_create("{} are different\n Table1: {}\n Table2: {}".format(
                    "qids",
                    tables_1 + "/qids",
                    tables_2 + "/qids",
                ), diff_resource_data)
                return

        for table in SAME_NUM_LINES:
            table_1 = yt_client.read_table(tables_1 + "/" + table)
            table_2 = yt_client.read_table(tables_2 + "/" + table)

            if sum(1 for _ in table_1) != sum(1 for _ in table_2):
                self.diff_create(
                    "different number of lines in {} and {}\n".format(
                        tables_1 + "/" + table,
                        tables_2 + "/" + table,
                    ),
                    diff_resource_data
                )
                return

        features = yt_client.read_table(tables_1 + "/features")
        if not list(features):
            self.diff_create(
                "features has no items, Table: {}".format(tables_1 + "/features"),
                diff_resource_data,
            )
            return
        if "factor_diff" in self.Parameters.path_1:  # until we understand for which mod it should work
            try:
                with sdk2.helpers.ProcessLog(self, logger="factor_diff") as pl:
                    cmd_line = [
                        "{}".format(str(sdk2.ResourceData(self.Parameters.check_diff).path)),
                        "--input1 {}".format(tables_1),
                        "--input2 {}".format(tables_2),
                        "--output //tmp/factor_diff/{}".format(self.id),
                    ]
                    sp.check_call(
                        " ".join(cmd_line),
                        shell=True,
                        stdout=pl.stdout,
                        stderr=pl.stderr,
                    )
            except Exception:
                self.set_info("gaiduk test says that smth go wrong")
                log_path = os.path.abspath(os.path.join(str(self.log_path()), "factor_diff.err.log"))
                with open(log_path) as diff_file:
                    content = diff_file.read()
                    self.Context.factor_diff = content
                    self.set_info(content)
                shutil.move(log_path, str(diff_resource_data.path))
                self.Context.has_diff = True
                diff_resource_data.ready()

                return

        fu.write_file(diff_resource_data.path, "No diff")
        self.set_info("There is no diff")
        diff_resource_data.ready()
        self.Context.has_diff = False

    def diff_create(self, message, diff_resource_data):
        fu.write_file(diff_resource_data.path, message)

        self.set_info(message)
        self.Context.has_diff = True
        diff_resource_data.ready()
