import datetime
import logging

from sandbox import sdk2

from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.common.search import bugbanner2
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.configs.prs_ops import PrsOpsCfg
from sandbox.projects.release_machine import rm_notify as rm_notify
from sandbox.projects.common.sdk_compat import task_helper


@rm_notify.notify2()
class PrsOpsCleanTables(bugbanner2.BugBannerTask):

    class Requirements(sdk2.Task.Requirements):
        ram = 40 * 1024
        disk_space = 5 * 1024

        environments = [
            PipEnvironment('yandex-yt', use_wheel=True),
            PipEnvironment('yandex-yt-yson-bindings-skynet', use_wheel=True)
        ]

    class Parameters(sdk2.Task.Parameters):
        frequency = sdk2.parameters.Integer("frequency", default_value=10)

    def on_enqueue(self):
        task_helper.ctx_field_set(self, rm_const.COMPONENT_CTX_KEY, PrsOpsCfg.name)

    def on_execute(self):

        self.add_bugbanner(bugbanner2.Banners.PrsOps)

        token = sdk2.Vault.data('prs_ops_yt_test')
        from yt.wrapper import YtClient
        yt_client = YtClient('hahn', token)

        cur_date = datetime.date.today()
        too_old = cur_date - datetime.timedelta(days=self.Parameters.frequency)
        logging.debug("cur_date: {}, too_old :{}".format(cur_date, too_old))
        tables_to_delete = []
        for i in yt_client.list("//home/prs_ops"):
            try:
                table_date = datetime.datetime.strptime(i[2:12], "%Y-%m-%d").date()
                if table_date < too_old:
                    tables_to_delete.append(i)
            except Exception as exc:
                eh.log_exception("probably test table, check {}".format(i), exc)

        logging.debug("Tables to delete: {}".format(tables_to_delete))

        for i in tables_to_delete:
            yt_client.remove("//home/prs_ops/{}".format(i), True)
