# coding: utf-8

import os
import logging
from sandbox import sdk2
from sandbox.projects.prs_ops import resources
from sandbox.projects.prs_ops import components
from sandbox.common.types.client import Tag
from sandbox.projects.common.search import bugbanner2
# from sandbox.projects import resource_types
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.configs.prs_ops import PrsOpsCfg
from sandbox.projects.release_machine import rm_notify as rm_notify
from sandbox.projects.common.sdk_compat import task_helper


@rm_notify.notify2()
class RunPrsOpsCasting(bugbanner2.BugBannerTask):
    """
    Run prs_ops_casting, get ratings and queries as input and return patched_requests as output resource
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 5 * 1024
        client_tags = Tag.GENERIC & Tag.Group.LINUX & ~Tag.LXC
        environments = [
            PipEnvironment('yandex-yt', version="0.8.29.post0", use_wheel=True),
            PipEnvironment('yandex-yt-yson-bindings-skynet', version="0.3.7.post1", use_wheel=True)
        ]

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 5 * 60 * 60

        prs_ops_binary_resource = sdk2.parameters.Resource(
            "prs_ops executable",
            # resourse_type=resources.PRS_OPS_EXECUTABLE,  # FIXME: invalid argument (SANDBOX-6404)
            required=True,
        )
        prs_ops_queries_resource = sdk2.parameters.Resource(
            "prs_ops queries",
            # resourse_type=resources.PRS_OPS_QUERIES,  # FIXME: invalid argument (SANDBOX-6404)
            required=True,
        )
        save_to = sdk2.parameters.String(
            "result folder on server (dir in //home/prs_ops/)",
            default="111111"
        )
        converter = sdk2.parameters.Resource(
            "pool_converter executable",
            # resourse_type=resource_types.POOL_CONVERTER_EXECUTABLE,  # FIXME: invalid argument (SANDBOX-6404)
        )
        reader = sdk2.parameters.Resource(
            "proto_pool_reader executable",
            # resourse_type=resource_types.PROTO_POOL_READER_EXECUTABLE,  # FIXME: invalid argument (SANDBOX-6404)
        )
        mapreduce = sdk2.parameters.Resource(
            "mapreduce_yt executable",
            # resourse_type=resource_types.MAPREDUCE_YT_EXECUTABLE,  # FIXME: invalid argument (SANDBOX-6404)
        )

    def on_enqueue(self):
        self.Context.save_to = "{}_id={}".format(self.Parameters.save_to, self.id)
        task_helper.ctx_field_set(self, rm_const.COMPONENT_CTX_KEY, PrsOpsCfg.name)

    def on_execute(self):

        self.add_bugbanner(bugbanner2.Banners.PrsOps)

        prs_ops = components.PrsOpsComponent(
            is_queries_full=True,
            binary=self.Parameters.prs_ops_binary_resource,
            queries=self.Parameters.prs_ops_queries_resource,
            write_mode="tsv",
            tm=False,
            mode="CASTING",
            task=self,
        )

        cur_path = os.getcwd()

        logging.info("run process")

        with prs_ops:
            pass

        resource = resources.PRS_OPS_REQUESTS(
            self,
            os.path.join(cur_path, "requests.tsv"),
            os.path.join(cur_path, "requests.tsv"),
        )
        sdk2.ResourceData(resource).ready()

        token = sdk2.Vault.data('prs_ops_yt_test')
        from yt.wrapper import YtClient
        prs_ops_env = dict()
        prs_ops_env["YT_PREFIX"] = "/"
        prs_ops_env["YT_TOKEN"] = token
        yt_client = YtClient('hahn', token)

        prs_ops2 = components.PrsOpsComponent(
            name="prs_ops2",
            binary=self.Parameters.prs_ops_binary_resource,
            requests=resource,
            write_mode="mr-proto",
            mr_server="hahn.yt.yandex.net",
            save_to="//home/prs_ops/{}".format(self.Context.save_to),
            mode="FEATURES",
            task=self,
            yt_client=yt_client,
            reader=self.Parameters.reader,
            converter=self.Parameters.converter,
            mapreduce=self.Parameters.mapreduce,
        )
        tmp_env = prs_ops2.get_environment()
        tmp_env.update(prs_ops_env)
        prs_ops2.set_environment(tmp_env)

        with prs_ops2:
            pass
