# coding: utf-8
from sandbox import sdk2


class PRS_OPS_EXECUTABLE(sdk2.Resource):
    """
        prs_ops binary
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    arcadia_build_path = 'quality/query_pool/prs_ops/prs_ops'
    releasers = ['mvel', 'sankear', 'i024', 'saku', 'coffeeman', 'andreippv', 'robot-testenv', 'robot-srch-releaser']
    release_subscribers = ['i024']


class PRS_OPS_FACTOR_DIFF(sdk2.Resource):
    """
        prs_ops factor_diff binary
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True
    arcadia_build_path = 'quality/query_pool/factor_diff/factor_diff'


class PRS_OPS_QUERIES(sdk2.Resource):
    """
    prs_ops input queries
    """
    readable = True
    any_arch = True
    executable = False
    used_for_testenv = sdk2.parameters.Bool("used_for_testenv")
    used_for_testenv_big = sdk2.parameters.Bool("used_for_testenv_big")


class PRS_OPS_RATINGS(sdk2.Resource):
    """
    prs_ops input ratings
    """
    readable = True
    any_arch = True
    executable = False
    used_for_testenv = sdk2.parameters.Bool("used_for_testenv")
    used_for_testenv_big = sdk2.parameters.Bool("used_for_testenv_big")


class PRS_OPS_DIFF(sdk2.Resource):
    """
    prs_ops diff output
    """
    readable = True
    any_arch = True
    executable = False


class PRS_OPS_LOG(sdk2.Resource):
    """
    prs_ops log files
    """
    readable = True
    any_arch = True
    executable = False


class PRS_OPS_REQUESTS(sdk2.Resource):
    """
    prs_ops requests
    """
    readable = True
    any_arch = True
    executable = False


class PRS_OPS_FEATURES(sdk2.Resource):
    """
    prs_ops features
    """
    readable = True
    any_arch = True
    executable = False


class PRS_OPS_FACTOR_SLICES(sdk2.Resource):
    """
    prs_ops factor_slices
    """
    readable = True
    any_arch = True
    executable = False
