# -*- coding: utf-8 -*-

import urllib

from sandbox import common
from sandbox.projects.pumpkin.BaseBuildPumpkinSerp import BaseBuildPumpkinSerp, RU_DOMAIN, TR_DOMAIN

_PUMPKIN_CGI_PARAMS = "exp_flags=pumpkin"
_NO_HEADER_PARAMS = "no_header=1"
_NONEXISTENT_SITE = "nonexistent-21a78042fde9.com"
_MEANINGLESS_QUERY = "jksaugjwhjhadrhwhwjhwl"


class WebBuildPumpkinSerp(BaseBuildPumpkinSerp):
    def do_before_execute_on_test_server(self):
        self.development_mode = True

    def _make_production_attributes(self, domain):
        if domain == RU_DOMAIN:
            return ("production_tag", "1")
        else:
            return ("production_tag_{}".format(domain), "1")

    def _make_serp_url(self, domain, text):
        return "{0}/yandsearch?text={1}&{2}".format(
            self._make_url(domain),
            urllib.quote(text), _PUMPKIN_CGI_PARAMS
        )

    def _make_serp_url_without_header(self, domain, text):
        return "{0}/yandsearch?text={1}&{2}&{3}".format(
            self._make_url(domain),
            urllib.quote(text),
            _PUMPKIN_CGI_PARAMS,
            _NO_HEADER_PARAMS
        )

    def _make_main_page_url(self, _):
        return None

    def _make_notfound_page_url(self, domain):
        return "{0}/yandsearch?text={1}%20site:{2}&{3}&noredirect=1".format(
            self._make_url(domain),
            urllib.quote(_MEANINGLESS_QUERY),
            _NONEXISTENT_SITE,
            _PUMPKIN_CGI_PARAMS
        )

    def _make_notfound_page_url_without_header(self, domain):
        return "{0}/yandsearch?text={1}%20site:{2}&{3}&{4}".format(
            self._make_url(domain),
            urllib.quote(_MEANINGLESS_QUERY),
            _NONEXISTENT_SITE,
            _PUMPKIN_CGI_PARAMS,
            _NO_HEADER_PARAMS
        )

    def _make_url(self, domain):
        url = super(WebBuildPumpkinSerp, self)._make_url(domain)
        if url is not None:
            return url

        if domain == RU_DOMAIN:
            return "https://yandex.ru"
        elif domain == TR_DOMAIN:
            return "https://yandex.com.tr"
        else:
            raise common.errors.TaskFailure("Unknown domain")

    def _make_test_task(self, urls_resource_id, serps_resource_id):
        from projects.pumpkin.WebTestPumpkinSerp import WebTestPumpkinSerp

        return WebTestPumpkinSerp(
            WebTestPumpkinSerp.current,
            description="Test task for {}".format(self.id),
            owner=self.owner,
            urls_resource_id=urls_resource_id,
            serp_resource_id=serps_resource_id,
            domain=self.Parameters.domain,
        )
