import os.path
import time
import logging
import sandbox.projects.common.network as network
from sandbox.projects.common.search.components import component


class GgrUiComponent(component.ProcessComponentMixin,
                     component.WaitPortComponentMixin,
                     component.Component):
    """Go Grid Router Ui for charts component"""

    def __init__(self, path, cwd, ggr, start_timeout=60, **kwargs):
        self._port = component.try_get_free_port()
        self._host = network.get_my_ipv6()
        self._cwd = cwd
        self._ggr = ggr
        self.__name = os.path.basename(path)
        args = [path,
                "-quota-dir", "{}".format(self._ggr.quota_dir),
                "-listen", ":{}".format(self._port),
                ]

        logging.info("Using port {} for {}".format(self._port, self.__name))

        component.ProcessComponentMixin.__init__(self, args, **kwargs)

        component.WaitPortComponentMixin.__init__(
            self,
            endpoints=[(self._host, self._port)],
            wait_timeout=start_timeout
        )

    @property
    def port(self):
        return int(self._port)

    @property
    def host(self):
        return "[{}]".format(str(self._host))

    def wait_while_running(self):
        while self.process.poll() is None:
            time.sleep(1)
