import os.path
import logging
from sandbox.projects.common.search.components import component


class SandboxRouterComponent(component.ProcessComponentMixin,
                             component.WaitUrlComponentMixin,
                             component.Component):
    """Sandbox router component"""
    TASK_TIMEOUT = "7h"
    START_HOUR = "0"
    STOP_HOUR = "0"
    REFRESH_PERIOD = "10s"

    def __init__(self, path, config, token, start_timeout=300, host="sandbox.yandex.net", schema="https"):
        self._port = component.try_get_free_port()
        self._host = "localhost"
        self.__name = os.path.basename(path)
        args = [path,
                "-listen", "{}:{}".format(self._host, self._port),
                "-conf", config,
                "-sandbox-host", host,
                "-sandbox-api-scheme", schema,
                "-start-hour", self.START_HOUR,
                "-stop-hour", self.STOP_HOUR,
                "-refresh-period", self.REFRESH_PERIOD,
                "-debug"
                ]

        logging.info("Using port {} for {}".format(self._port, self.__name))

        component.ProcessComponentMixin.__init__(self, args)

        component.WaitUrlComponentMixin.__init__(
            self,
            url="http://{}:{}/status".format(self._host, self._port),
            wait_timeout=start_timeout
        )
        self.set_environment({"SANDBOX_TASK_TOKEN": token})

    @property
    def port(self):
        return int(self._port)

    @property
    def host(self):
        return self._host
