import os.path
import logging
import sandbox.projects.common.network as network
from sandbox.projects.common.search.components import component


class SocatLauncher(component.ProcessComponentMixin,
                    component.WaitPortComponentMixin,
                    component.Component):
    """socat component to redirect ipv6 connection to ipv4 on localhost
    socat TCP6-LISTEN:4444,bind=[2a02:6b8:c04:1ad:0:663:77d3:6dc4],fork TCP:localhost:4444
    """
    BIN_PATH = "socat"

    def __init__(self, port=4444, start_timeout=60, **kwargs):
        self._port = port
        self._host = network.get_my_ipv6()

        self.__name = os.path.basename(SocatLauncher.BIN_PATH)
        args = [SocatLauncher.BIN_PATH,
                "-d", "-d", "-d",
                "TCP6-LISTEN:{port},bind=[{ipv6}],fork,forever".format(port=self._port, ipv6=self._host),
                "TCP:localhost:{port}".format(port=self._port)
                ]

        logging.info("Using port {} for {}".format(self._port, self.__name))

        component.ProcessComponentMixin.__init__(self, args, **kwargs)

        component.WaitPortComponentMixin.__init__(
            self,
            endpoints=[(self._host, self._port)],
            wait_timeout=start_timeout
        )

    @property
    def port(self):
        return int(self._port)

    @property
    def host(self):
        return str(self._host)
