import os.path
import logging
from sandbox.projects.common.search.components import component


class VncLauncher(component.ProcessComponentMixin,
                  component.WaitPortComponentMixin,
                  component.Component):
    """VNC component
    x11vnc -display ":99" -passwd selenoid -shared -forever -loop500 -rfbport 5900 -rfbportv6 5900
    """

    VNC_BIN = "x11vnc"

    def __init__(self, offset=0, **kwargs):
        self._port = 5900 + offset

        self.__name = os.path.basename(VncLauncher.VNC_BIN)
        args = [VncLauncher.VNC_BIN,
                "-display", ":{}".format(100+offset),
                "-passwd", "selenoid",
                "-shared",
                "-forever",
                "-loop500",
                "-rfbport", str(self._port),
                "-rfbportv6", str(self._port)
                ]

        logging.info("Using port {} for {}".format(self._port, self.__name))

        component.ProcessComponentMixin.__init__(self, args, **kwargs)
        component.WaitPortComponentMixin.__init__(self, endpoints=[("localhost", self._port)])
