import sandbox.sdk2 as sdk2


class SeleniumGridRouter(sdk2.Resource):
    releasable = True
    releasers = ["g:selenium-dev", "aokhotin", "dmitko", "vania-pooh", "g:infra-devux", "g:infra-sre", "g:infra-mm"]


class SeleniumGgrUi(sdk2.Resource):
    releasable = True
    releasers = ["g:selenium-dev", "aokhotin", "dmitko", "vania-pooh", "g:infra-devux", "g:infra-sre", "g:infra-mm"]


class SeleniumSandboxRouter(sdk2.Resource):
    releasable = True
    releasers = ["g:selenium-dev", "aokhotin", "dmitko", "vania-pooh", "g:infra-devux", "g:infra-sre", "g:infra-mm"]


class SeleniumQemuImage(sdk2.Resource):
    releasable = True
    releasers = ["g:selenium-dev", "aokhotin", "dmitko", "vania-pooh", "g:infra-devux", "g:infra-sre", "g:infra-mm"]
    browser = sdk2.Attributes.String("Browser name")
    version = sdk2.Attributes.String("Browser version")
    ncpu = sdk2.Attributes.Integer("ncpu required for image")
    ram = sdk2.Attributes.Integer("ram required for image")
    disk = sdk2.Attributes.Integer("disk required for image")
    processes = sdk2.Attributes.Integer("browser processes inside the image")


class SeleniumPlatformConfig(sdk2.Resource):
    releasable = True
    releasers = ["g:selenium-dev", "g:infra-devux", "g:infra-sre", "g:infra-mm", "aokhotin", "dmitko", "vania-pooh", "dudkevich"]
