# -*- coding: utf-8 -*-

import os
import platform
import shutil

from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.parameters import Container
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.task import SandboxTask


class ContainerParameter(Container):
    required = True
    default_value = '275193263'
    description = "Container"


class BuildPlatformBaseImages(SandboxTask):
    """ Task for building base images hierarchy """

    privileged = True
    type = 'BUILD_PLATFORM_BASE_IMAGES'
    input_parameters = [ContainerParameter]
    environments = (
        environments.SvnEnvironment(),
        environments.SvnEnvironment(platform=platform.platform())
    )
    root_dir = None

    def on_prepare(self):
        self.root_dir = svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/")

    def on_execute(self):
        task_dir = os.path.dirname(os.path.realpath(__file__))
        root = self.abs_path("src_dir")
        if os.path.exists(root):
            shutil.rmtree(root)
        upper = os.path.join(root, "upper")
        work = os.path.join(root, "work")
        merged = os.path.join(root, "merged")
        docker = os.path.join(root, "docker")
        map(os.mkdir, (root, upper, work, merged, docker))
        run_process(
            ['/bin/mount', '-t', 'overlay', 'overlay', '-olowerdir={},upperdir={},workdir={}'.format(self.root_dir, upper, work), merged],
            log_prefix='overlay'
        )
        token = self.get_vault_data(self.owner, 'robot_qloud_client_token')
        docksock = 'unix://' + os.path.join(docker, 'docker.sock')
        run_process(['/bin/bash', os.path.join(task_dir, 'docker_setup.sh'), docker], log_prefix='docker-setup', shell=True)
        run_process(['docker', 'login', '-u', 'robot-qloud-client', '-p', token, 'registry.yandex.net'], log_prefix='docker-login', environment=dict(DOCKER_HOST=docksock))
        base = os.path.join(merged, 'infra', 'qloud', 'base-images')
        pybin_variants = ['/skynet/python/bin/python', '/usr/bin/python']
        pybin = None
        for i in pybin_variants:
            if os.path.exists(i):
                pybin = i
        if pybin is None:
            raise Exception('no python binary found in ' + ",".join(pybin_variants))

        run_process(
            [pybin, os.path.join(base, 'make.py')],
            environment=dict(
                PATH=os.getenv('PATH'),
                OAUTH=token,
                DOCKER_HOST=docksock
            ),
            work_dir=base,
            log_prefix='makepy',
            shell=True
        )


__Task__ = BuildPlatformBaseImages
