# coding: utf-8
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter

from sandbox import sdk2

ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/qe/auth/auth-standalone/'


class QloudAuthStandalone(sdk2.resource.AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['torkve', 'oplachkin', 'QLOUD-DEV']


class ImportAuthStandalone(BuildFromArtifactoryTask):
    """
        Get auth jar from maven, make it a resource and register in nanny on release
    """
    type = 'IMPORT_QLOUD_AUTH_STANDALONE'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'Auth artifact version')
    ]

    def _resource_path(self):
        return "auth-standalone.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "auth-standalone-{version}-runnable.jar"

    def _resource_type(self):
        return QloudAuthStandalone

    def _resource_id_context_key(self):
        return 'auth_standalone_jar_id'


__Task__ = ImportAuthStandalone
