# coding: utf-8
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter

from sandbox import sdk2

ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/qe/ip-broker/ip-broker-standalone/'


class QloudIpBrokerStandalone(sdk2.resource.AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['crastin', 'QLOUD-DEV']


class ImportIpBrokerStandalone(BuildFromArtifactoryTask):
    """
        Get ip-broker jar from maven, make it a resource and register in nanny on release
    """
    type = 'IMPORT_QLOUD_IP_BROKER_STANDALONE'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'Ip-broker artifact version')
    ]

    def _resource_path(self):
        return "ip-broker-standalone.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "ip-broker-standalone-{version}-runnable.jar"

    def _resource_type(self):
        return QloudIpBrokerStandalone

    def _resource_id_context_key(self):
        return 'auth_standalone_jar_id'


__Task__ = ImportIpBrokerStandalone
