# -*- coding: utf-8 -*-

import logging
import logging.handlers
import time
import os
from sandbox.projects.common import file_utils as fu

from sandbox import sdk2
from sandbox.projects.tank.ShootViaTankapi import ShootViaTankapi
from sandbox.common.types import task as ctt

TANKS = [
    'tank-1.tank.upstreams.loadtest.qloud.test.qloud-d.yandex.net:8083'
]


def logger():
    loggerr = logging.getLogger('%s_%s' % (__name__, time.time()))
    loggerr.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s %(levelname)s [%(processName)s: %(threadName)s] %(message)s')
    file_handler = logging.handlers.RotatingFileHandler(
        'qloud_balancer_metashooting.log',
        maxBytes=1024 * 1024,
        backupCount=5
    )

    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(formatter)
    loggerr.addHandler(file_handler)
    return loggerr


class LoadtestQloudBalancer(sdk2.Task):
    """ Task for shooting on Qloud Balancer st/QLOUD-2781 """

    def start_shooting(self, desc, ammo_source, ammo_resource, config_content):
        subtask_shoot = ShootViaTankapi(
            self,
            description=desc,
            ammo_source=ammo_source,
            ammo_resource=ammo_resource,
            config_source='file',
            config_content=config_content,
            tanks=TANKS
        ).enqueue()
        logger().info('Subtask with shooting is started')
        raise sdk2.WaitTask([subtask_shoot.id], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True,
                            timeout=14400)

    def on_execute(self):

        task_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
        logging.info(task_dir)
        tank_configs = os.listdir(os.path.join(task_dir, 'LoadtestQloudBalancer/config'))
        logger().info('Shooting configs: %s', tank_configs)

        for conf_name in tank_configs:
            if conf_name.endswith(".yaml"):
                with self.memoize_stage["shooting_{0}".format(conf_name)]:
                    config_content = fu.read_file(os.path.join(task_dir, 'LoadtestQloudBalancer/config/', conf_name))
                    self.start_shooting(conf_name, 'in_config', '', config_content)
