# coding: utf-8
import datetime
import os
import time
import urllib

from sandbox.sandboxsdk import task


class RunMetricAggregator(task.SandboxTask):
    _url = "http://qloud-metric-aggregator.n.yandex-team.ru/schedule?point="
    _oneHourMillisecond = 3600000

    def on_execute(self):

        count = 10

        if not os.path.exists("lock.txt"):
            exit(-1)

        with open("lock.txt", "r") as f:
            ts = int(f.readline())

        while True:
            if count == 0:
                time.sleep(30)
                count = 10
            f = urllib.request.urlopen(self._url + str(ts), timeout=10000)
            request = f.read()
            if request:
                count -= 1
                continue
            else:
                print("Good request: " + str(ts))
                with open("lock.txt", "w+") as f:
                    f.write(str(ts))
                count = 10
                ts += self._oneHourMillisecond
                if ts > int(datetime.datetime.now().timestamp() * 1000):
                    print("End")
                    break
