# -*- coding: utf-8 -*-

from sandbox import sdk2  # noqa
from sandbox.sdk2 import service_resources  # noqa
from sandbox.projects.porto.common.resource_types import QEMU_IMAGE_RTC

TEAM_MATES = ['RCCS-ADMINS', 'xgen', 'x0leg', 'yushkovsky', 'vminkov', 'amich', 'crastin', 'danichk']


class PORTO_LAYER_DOCKER_REGISTRY(sdk2.Resource):
    '''
        Layer with docker-registry microservices | QLOUDOPS-2318
    '''
    auto_backup = True
    releasable = True
    releasers = TEAM_MATES


class PORTO_LAYER_DOCKER_REGISTRY_ZOOKEEPER(sdk2.Resource):
    '''
        Layer with zookeeper | QLOUDOPS-2318
    '''
    auto_backup = True
    releasable = True
    releasers = TEAM_MATES


class DOCKER_REGISTRY_CONFIGS(sdk2.Resource):
    '''
        Archive with configuration files for docker-registry microservices | QLOUDOPS-2318
    '''
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = TEAM_MATES
    release_subscribers = ['xgen']
    share = False


class QEMU_IMAGE_QLOUD_TC(QEMU_IMAGE_RTC):
    releasers = TEAM_MATES
