# -*- coding: utf-8 -*-
from sandbox import sdk2


class FactorsConfig(sdk2.resource.AbstractResource):
    """
    ShardConfig in test format
    """
    auto_backup = True
    valid = False
    releasable = True


class FactorsDependenciesDump(sdk2.resource.AbstractResource):
    """
    Dump of factors dependencies in prototext format
    """
    readable = True
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ["WEB_RELEVANCE"]


class BertModelsArchive(sdk2.resource.AbstractResource):
    """
    Bert Models Archiv
    """
    auto_backup = True
    valid = False


class MkbrBinary(sdk2.Resource):
    """
    mkbr package
    """
    releasable = True
    auto_backup = True
    # https://sandbox.yandex-team.ru/admin/groups/WEB_RELEVANCE
    releasers = ["WEB_RELEVANCE", "robot-search-monitor"]


class RelevToolsViewerPackage(sdk2.Resource):
    releasable = True
    auto_backup = True
    # https://sandbox.yandex-team.ru/admin/groups/WEB_RELEVANCE
    releasers = ["WEB_RELEVANCE", "robot-relev-tools-ci"]
