from sandbox.common.enum import Enum


class ImageBuildtype(Enum):
    """
    BUILDTYPE of android images.
    See https://source.android.com/setup/building#choose-a-target
    """
    ENGINEERING = 'eng'
    USERDEBUG = 'userdebug'
    USER = 'user'


class LinkplayImageBuildType(Enum):
    """
    Build type for images for Linkplay-based devices for which we don't have
    sources. For such devices we have only binary files (kernel, device tree, etc.)
    and rootfs. So build type of such devices is different than the one
    for devices with firmwares for which we have source because we cannot
    have kernel built with debug config.
    """
    DEBUG = 'debug'
    RELEASE = 'release'


class BuildrootImageBuildType(Enum):
    """
    Build type of Buildroot images.
    """
    DEBUG = 'debug'
    RELEASE = 'release'
    RELEASE_FACTORY = 'release factory'


class Yandexmini2BuildrootImageBuildType(Enum):
    """
    Build type of Buildroot images for Yandexmini2.
    """
    FACTORY = 'factory'
    USER = 'user'
    ENG = 'eng'
    HW_TEST = 'hw_test'
    SL_LINUX = 'sl_linux'


class YandexmidiBuildrootImageBuildType(Enum):
    """
    Build type of Buildroot images for Yandexmidi.
    """
    USER = 'user'
    ENG = 'eng'
    HW_TEST = 'hw_test'
    SL_LINUX = 'sl_linux'


class YandexmicroBuildrootImageBuildType(Enum):
    """
    Build type of Buildroot images for Yandexmicro.
    """
    USER = 'user'
    ENG = 'eng'
    SL_LINUX = 'sl_linux'


class SaturnBuildrootImageBuildType(Enum):
    """
    Build type of Buildroot images for Saturn.
    """
    USER = 'user'
    ENG = 'eng'
    HW_TEST = 'hw_test'
    SL_LINUX = 'sl_linux'


class TvAppsBuildType(Enum):
    """
    BUILDTYPE of prebuilt TV Apps.
    https://bb.yandex-team.ru/projects/YANDEX-TV/repos/vendor_yandex_prebuit/browse/artifact_downloader/main.py#18
    """
    Enum.lower_case()

    QA = None
    PRESTABLE = None  # deprecated: renamed to QA
    DEBUG = None
    RELEASE = None
