# -*- coding: utf-8 -*-

import sandbox.sdk2 as sdk2
# from sandbox.sdk2 import yav
import sandbox.common as common

import logging
import requests
import json

# Quasar-Alerts, Releases
CHAT_IDS = ['-1001196139371',  # Quasar-Alerts
            '-1001611475556']  # NDA OPS


class QuasarNotifyAboutExperimentIsOnAir(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        experiment = sdk2.parameters.String('Experiment to check', required=True)
        state = sdk2.parameters.String('Check state', required=True)

    def send_message_via_telegram(self, message, bot_token):
        logging.info('Try send message "{}" via telegram'.format(
            message
        ))
        for chat_id in CHAT_IDS:
            try:
                headers = {'content-type': 'application/json'}
                data = {"chat_id": chat_id, "text": message, "parse_mode": "HTML"}
                r = requests.post('https://api.telegram.org/bot{}/sendMessage'.format(bot_token), headers=headers, data=json.dumps(data))
                if r.status_code != 200:
                    logging.error('Failed to send message via telegram, resp code = {}, with message {}'.format(r.status_code, r.json()))
                else:
                    logging.info('Success send message via telegram')
            except common.rest.Client.HTTPError as e:
                logging.error('Failed to send message via telegram, exception {}'.format(e))

    def on_execute(self):
        if self.Parameters.state != 'RUNNING':
            logging.info('State = {}, experiment = {}. Do not do anything.', self.Parameters.state, self.Parameters.experiment)
            return
        r = requests.get('https://ab.yandex-team.ru/api/task/{}'.format(self.Parameters.experiment))
        if r.status_code != 200:
            raise Exception("AB API returned non OK code for experiment {}: {}".format(self.Parameters.experiment, r.status_code))

        response_body = r.json()
        has_required_service = False
        if 'hash_slice_detailed' in response_body:
            for hash_slice_detailed in response_body['hash_slice_detailed']:
                if 'restrictions' in hash_slice_detailed and 'services' in hash_slice_detailed['restrictions'] and 'quasar' in hash_slice_detailed['restrictions']['services'].split(','):
                    has_required_service = True
                    break
        if has_required_service:
            # temp decision
            secret_owner = 'QUASAR'
            secret_name = 'robot-quasar-telegram-token'
            bot_token = sdk2.Vault.data(secret_owner, secret_name)

            # secret = yav.Secret("sec-01ewnvmhgjfkbgahh95zgdnk7c")
            # bot_token = secret.data()["telegram-token"]
            title = response_body['title']
            text = 'Сейчас запускается <a href="https://st.yandex-team.ru/{0}">{0}</a>\n\n<b>{1}</b>'.format(self.Parameters.experiment, title)
            self.send_message_via_telegram(text, bot_token)
