# coding: utf-8
from json import JSONEncoder
from datetime import date
from sandbox import sdk2
from sandbox.common import errors
from sandbox.projects.saas.common.classes import SaasBinaryTask
import sandbox.common.types.misc as ctm


class DateEncoder(JSONEncoder):
    def default(self, obj):
        if isinstance(obj, date):
            return str(obj)
        return JSONEncoder.default(self, obj)


class FetchEventCounts(SaasBinaryTask):
    # upload to sandbox via ./fetch_jangles_data upload --attr 'name=FetchEventCounts' and release resource
    TASKS_RESOURCE_NAME = "FetchEventCounts"
    LOCAL_PORT = 5432
    CHYT_CLIQUE = "*ch_public"

    class Requirements(sdk2.Requirements):
        cores = 1  # vCores
        ram = 1024  # Mb
        disk_space = 2 * 1024
        dns = ctm.DnsType.DNS64
        environments = [sdk2.environments.PipEnvironment("yandex-yt")]

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        enable_yav = True
        with sdk2.parameters.Group("SSH"):
            ssh_user = sdk2.parameters.String("SSH user", default="yandex")
            ssh_host = sdk2.parameters.String("SSH host", default="changhong.jangles.yandex")
            ssh_port = sdk2.parameters.Integer("SSH port", default=8541)
            psql_remote_host = sdk2.parameters.String("SSH remote host", default="127.0.0.1")
            psql_remote_port = sdk2.parameters.Integer("SSH remote port", default=5432)

        with sdk2.parameters.Group("YT"):
            with sdk2.parameters.RadioGroup("YT Cluster") as yt_cluster:
                yt_cluster.values.hahn = yt_cluster.Value(value="hahn", default=True)
                yt_cluster.values.arnold = yt_cluster.Value(value="arnold")
            yt_path = sdk2.parameters.String("Target table", required=True)
            yt_secret = sdk2.parameters.YavSecret(
                "YAV secret YT token", default="sec-01d2ffwrdbwyj37zkj4r8zegsn"
            )
            yt_secret_key = sdk2.parameters.String(
                "Key to extract from YAV secret", default_value="robot-quasar-yt-token"
            )

        with sdk2.parameters.Group("YAV"):
            yav_secret = sdk2.parameters.YavSecret(
                "YAV factory secret", default="sec-01erq8dcwb1q2m72v7hk5whfwb"
            )
            yav_ssh_key_field = sdk2.parameters.String(
                "Key to extract from YAV secret", default_value="yandex.key"
            )
            yav_psql_passwd_key = sdk2.parameters.String(
                "Key to extract PSQL password from YAV secret",
                default_value="vault_postgresql_password",
            )

        with sdk2.parameters.Group("PostgreSQL"):
            psql_db_name = sdk2.parameters.String("PSQL DB name", default="jangles")
            psql_db_user = sdk2.parameters.String("PSQL user", default="jangles")
            psql_chamber_filter = sdk2.parameters.String(
                "SQL 'like' filter for 'chamber_id' field",
                default="micro-jig-station-%",
                required=True,
            )
            psql_today_flag = sdk2.parameters.Bool("Download only for today", default=False)

    def on_execute(self):
        raise errors.TaskError('Task sources moved to /quasar/manufacturing/sandbox/fetch_events_count')
