# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from sandbox import common
from sandbox import sdk2
from sandbox.projects.saas.common.classes import SaasBinaryTask

MILLION = 10 ** 6

DEVICES_WITHOUT_ETH = (
    'yandexmicro',
    'yandexmodule_2',
    'yandexmidi'
)


class FetchJanglesData(SaasBinaryTask):
    # upload to sandbox via ./fetch_jangles_data upload --attr 'name=FetchJanglesData' and release resource
    TASKS_RESOURCE_NAME = 'FetchJanglesData'
    LOCAL_PORT = 8080
    JANGLES_HANDLER_PATH = 'device_info_package/export_ready'
    CHYT_CLIQUE = '*ch_public'

    class Requirements(sdk2.Requirements):
        cores = 1  # vCores
        ram = 1024  # Mb
        disk_space = 2 * 1024

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('SSH'):
            user = sdk2.parameters.String('SSH user', default='yandex')
            host = sdk2.parameters.String('SSH host', default='fenda.ext.eine.yandex.net')
            port = sdk2.parameters.Integer('SSH port', default=1222)
            remote_host = sdk2.parameters.String('SSH remote host', default='10.10.0.1')
            remote_port = sdk2.parameters.Integer('SSH remote port', default=8080)

        with sdk2.parameters.Group('Filters'):
            ignore_ready_for_ship = sdk2.parameters.Bool(
                'Ignore ready to ship status',
                description='Fetch ALL devices with assigned device_id',
                required=True, default=False
            )
            baked_after_timestamp = sdk2.parameters.Integer('Baked after timestamp', required=False, default=0)
            baked_before_timestamp = sdk2.parameters.Integer('Baked before timestamp', required=False, default=0)
            device_model = sdk2.parameters.String('Device model', default='yandex_station_pro')

        with sdk2.parameters.Group('YT'):
            with sdk2.parameters.RadioGroup('YT Cluster') as yt_cluster:
                yt_cluster.values.hahn = yt_cluster.Value(value='hahn', default=True)
                yt_cluster.values.arnold = yt_cluster.Value(value='arnold')
            yt_path = sdk2.parameters.String('Target table', required=True)
            yt_secret = sdk2.parameters.YavSecret('YAV secret YT token', default='sec-01d2ffwrdbwyj37zkj4r8zegsn')
            yt_secret_key = sdk2.parameters.String('Key to extract from YAV secret',
                                                   default_value='robot-quasar-yt-token')

        with sdk2.parameters.Group('YAV'):
            yav_secret = sdk2.parameters.YavSecret('YAV secret with ssh key', default='sec-01dh4eer2d3pt81r5jfvezqefn')
            yav_secret_key = sdk2.parameters.String('Key to extract from YAV secret', default_value='yandex.key')

    def on_execute(self):
        raise common.errors.TaskError('Task sources moved to /quasar/manufacturing/sandbox/fetch_jangles_data')
