import shutil
import sandbox.common.types.task as ctt

from sandbox import sdk2

from sandbox.projects.resource_types import GEODATATZDATA_STABLE
from sandbox.projects.geobase.Geodata6BinQuasarStable import GEODATA6BIN_QUASAR_STABLE
from sandbox.projects.quasar.resource_types import QuasarGeodata

from sandbox.projects.common.geosearch.utils import unpack_file


class QuasarGeodataBuilder(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        geodata_resource = sdk2.parameters.LastReleasedResource('geodata6-quasar.bin',
                                                                resource_type=GEODATA6BIN_QUASAR_STABLE)
        timezones = sdk2.parameters.LastReleasedResource('tzdata', resource_type=GEODATATZDATA_STABLE)

    def on_execute(self):
        resource = QuasarGeodata(self, 'A directory with last released geodata and timezones', 'quasar_geodata')
        geodata = sdk2.ResourceData(resource)
        geodata.path.mkdir()

        geodata6_quasar = sdk2.ResourceData(self.Parameters.geodata_resource)
        sdk2.paths.copy_path(str(geodata6_quasar.path), str(geodata.path))

        tzdata = sdk2.ResourceData(self.Parameters.timezones)
        unpack_file(str(tzdata.path), str(geodata.path))
        shutil.rmtree(str(geodata.path.joinpath('zones2')))

        geodata.ready()

    def on_success(self, prev_status):
        self.mark_released_resources(ctt.ReleaseStatus.STABLE)
