class DownloadInfo(object):
    pass


class DownloadableModule(object):
    def __init__(self, default_artifact):
        # type: (DownloadInfo) -> None
        self.default_artifact = default_artifact


class AppMetadata(object):
    def __init__(self, module_name, certificate=None, privileged=None, owner=None, private_apis=None,
                 overrides_packages=None, vendor_module=None, system_only_module=False):
        # type: (str, str, bool, str, bool, str, bool, bool) -> None
        self.module_name = module_name
        self.module_class = 'APPS'
        self.certificate = certificate
        self.privileged = privileged
        self.owner = owner
        self.private_apis = private_apis
        self.overrides_packages = overrides_packages
        self.vendor_module = vendor_module
        self.system_only_module = system_only_module


class DownloadableAppModule(DownloadableModule):
    def __init__(self, metadata, default_artifact, platforms=None):
        # type: (AppMetadata, DownloadInfo, list) -> None
        super(DownloadableAppModule, self).__init__(default_artifact)
        self.metadata = metadata
        self.platforms = platforms


class MkFileInfo(object):
    def __init__(self, name, header):
        # type: (str, str) -> None
        self.name = name
        self.header = header


class TeamcityDownloadInfo(DownloadInfo):
    def __init__(
        self, base_url, project_id, artifact_pattern,
        build_id=None, branch=None, is_folder=False, ext=None, auth_token=None,
    ):
        # type: (str, str, str, str, str, bool, str, str) -> None
        self.base_url = base_url
        self.project_id = project_id
        self.artifact_pattern = artifact_pattern
        self.build_id = build_id
        self.branch = branch
        self.is_folder = is_folder
        self.ext = ext
        self.auth_token = auth_token

    def __str__(self):
        return '< projectId={} pattern={} >'.format(self.project_id, self.artifact_pattern)

    def build_upon(self, base_url=None, project_id=None, build_id=None,
                   artifact_pattern=None):
        # type: (str, str, str, str) -> TeamcityDownloadInfo
        return TeamcityDownloadInfo(
            base_url=base_url if base_url else self.base_url,
            project_id=project_id if project_id else self.project_id,
            build_id=build_id if build_id else self.build_id,
            artifact_pattern=artifact_pattern if artifact_pattern else self.artifact_pattern
        )


class WebDownloadInfo(DownloadInfo):
    def __init__(self, url, auth_token=None):
        # type: (str, str) -> None
        self.url = url
        self.auth_token = auth_token


class SandboxResourceInfo(DownloadInfo):
    """
    :param resource_id: what resource to take
    :param path_in_resource: what item of resource to extract as target item (if resource is meant to be a directory). Optional, defaults to "take whole resource".
    """
    def __init__(self, resource_id, path_in_resource=None):
        # type: (str, str) -> None
        self.resource_id = resource_id
        self.path_in_resource = path_in_resource


class ArtifactFolderInfo(DownloadableModule):
    def __init__(self, folder_name, ext, default_artifact=None):
        # type: (str, str, DownloadInfo) -> None
        super(ArtifactFolderInfo, self).__init__(default_artifact)
        self.folder_name = folder_name
        self.ext = ext
