import json
from typing import List, Tuple

from sandbox import sdk2
from sandbox.sandboxsdk import paths, process

from .engine import DownloadEngine
from .models import SandboxResourceInfo


def add_write_permissions(path):
    process.run_process(
        "chmod +w -R {}".format(path),
        shell=True,
        log_prefix='chmod_plus_w',
    )


class SandboxDownloadEngine(DownloadEngine):
    def download_artifact(self, download_info, dest):
        # type: (SandboxResourceInfo, str) -> List[Tuple[str, str]]
        resource = sdk2.Resource[download_info.resource_id]
        resource_data = sdk2.ResourceData(resource)

        src_path = resource_data.path
        if download_info.path_in_resource:
            src_path = src_path.joinpath(download_info.path_in_resource)

        paths.copy_path(str(src_path), dest)
        add_write_permissions(dest)

        return [("sbr:{}".format(resource.id), json.dumps(resource.__attrs__))]
