import sandbox.sdk2 as sdk2

import sandbox.projects.quasar.utils as quasar_utils
import sandbox.projects.quasar.resource_types as qrt
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.image_builds.base_image_build.quasar as quasar_base
import sandbox.projects.quasar.image_builds.base_image_build.amlogic_android as amlogic_android_base
import sandbox.projects.quasar.image_builds.chiron.base as chiron_base


class QuasarBuildChironImage(amlogic_android_base.QuasarBuildAmlogicAndroidImage):
    class ArtifactsConfig(object):
        image_resource_type = qrt.QuasarChironImage
        ota_resource_type = qrt.QuasarChironOTAImage
        target_files_resource = qrt.QuasarChironTargetFiles

    class Parameters(amlogic_android_base.QuasarBuildAmlogicAndroidImage.Parameters):
        param_creator = quasar_base.ParameterCreator(quasar_platform.Platform.CENTAUR)
        custom_manifest = param_creator.create_custom_manifest_parameter()
        ota_max_size = param_creator.create_ota_max_size_parameter()

        # FIXME Change default
        sign_keys_secret = sdk2.parameters.String(
            'YAV secret with ota keys tarball, should have file keys.tgz',
            default='ver-01fxqkw68rztgtx6gadx7tm9kq')
        secureboot_keys_secret = sdk2.parameters.String(
            'YAV secret with secureboot keys tarball, should have files: aml-user-key.sig',
            default='ver-01g0cjxc1dkwcg90dgrb8rz56y')
        tdk_key_secret = sdk2.parameters.String(
            'YAV secret with tdk private key: tdk_keys.tgz',
            default='ver-01g3rt92n7e7e4z14hc35qm67a')
        # FIXME Change default
        rabbit_hole_key_secret = sdk2.parameters.String(
            'YAV secret with rabbit_hole rsa private key: rh_public.pem',
            default='ver-01fzzses1z6z6sqprkz1sw97vt')
        # FIXME Change default
        avb_key_secret = sdk2.parameters.String(
            'YAV secret with avb rsa private key: avb_private.pem',
            default='ver-01fx7yvgw86kpqmfbvp15bezag')

        _container = quasar_utils.LastStableContainer(
            'Execution container', resource_type=qrt.QuasarYandexSmartDeviceLxcImage)

    class BuildConfig(chiron_base.ChironBuildConfig):
        downloaded_artifacts_config = qrt.QuasarCentaurArtifactsConfig
        downloaded_artifacts = qrt.QuasarCentaurArtifacts
