from sandbox import sdk2

from sandbox.projects.quasar import platform
from sandbox.projects.quasar import resource_types as qrt
from sandbox.projects.quasar import utils as quasar_utils
from sandbox.projects.quasar.image_builds.base_image_build import quasar as quasar_base
from sandbox.projects.quasar.image_builds.base_image_build import linkplay as linkplay_base


class QuasarBuildElariA98Image(linkplay_base.QuasarLinkplayImageBuildTask):
    """
    Build full image for quasar ElariA98 device and publish it as a resource
    """

    class Parameters(linkplay_base.QuasarLinkplayImageBuildTask.Parameters):
        param_creator = quasar_base.ParameterCreator(platform.Platform.ELARI_A98)

        ota_max_size = param_creator.create_ota_max_size_parameter()
        quasar_daemons = param_creator.create_daemons_parameter()

        include_mcu_image = sdk2.parameters.Bool('Include MCU image (uImage_ota_mcu_packed.bin) into build', default=False)
        mcu_image_name = sdk2.parameters.String('MCU image name', required=False, default='uImage_ota_mcu_packed.bin')

        _container = quasar_utils.LastStableContainer(
            'Execution container',
            resource_type=qrt.QuasarLinkplayA98LxcImage)

    class BuildConfig(linkplay_base.QuasarLinkplayImageBuildTask.BuildConfig):
        @property
        def platform(self):
            return platform.Platform.ELARI_A98

        @property
        def ota_resource_type(self):
            return qrt.QuasarElariA98OTAImage

        @property
        def default_repository_url(self):
            return 'ssh://bb.yandex-team.ru/quas/elaria98-firmware.git'

        @property
        def build_params(self):
            params = super(QuasarBuildElariA98Image.BuildConfig, self).build_params
            if self.task.Parameters.include_mcu_image:
                params.append(self.task.Parameters.mcu_image_name)
            return params
