from sandbox import sdk2

from sandbox.projects.quasar import platform
from sandbox.projects.quasar import resource_types as qrt
from sandbox.projects.quasar.image_builds.base_image_build import quasar as quasar_base
from sandbox.projects.quasar.image_builds.base_image_build import jbl as jbl_base


class QuasarBuildJblLinkMusicImage(jbl_base.QuasarBaseJblImageBuildTask):
    """
    Build full image for quasar JBL Link Music device and publish it as a resource
    """

    class Parameters(jbl_base.QuasarBaseJblImageBuildTask.Parameters):
        param_creator = quasar_base.ParameterCreator(platform.Platform.JBL_LINK_MUSIC)

        ota_max_size = param_creator.create_ota_max_size_parameter()
        quasar_daemons = param_creator.create_daemons_parameter()

        keys_yav_version = sdk2.parameters.String(
            'Keys yav version', default='ver-01dzh9a4km5brr0p450hwbkka2')

    class BuildConfig(jbl_base.QuasarBaseJblImageBuildTask.BuildConfig):
        @property
        def platform(self):
            return platform.Platform.JBL_LINK_MUSIC

        @property
        def image_resource_type(self):
            return qrt.QuasarJblLinkMusicImage

        @property
        def ota_resource_type(self):
            return qrt.QuasarJblLinkMusicOTAImage
