from sandbox import sdk2

from sandbox.projects.quasar import platform
from sandbox.projects.quasar import resource_types as qrt
from sandbox.projects.quasar.image_builds.base_image_build import quasar as quasar_base
from sandbox.projects.quasar.image_builds.base_image_build import jbl as jbl_base


class QuasarBuildJblLinkPortableImage(jbl_base.QuasarBaseJblImageBuildTask):
    """
    Build full image for quasar JBL Link Music device and publish it as a resource
    """

    class Parameters(jbl_base.QuasarBaseJblImageBuildTask.Parameters):
        param_creator = quasar_base.ParameterCreator(platform.Platform.JBL_LINK_PORTABLE)

        ota_max_size = param_creator.create_ota_max_size_parameter()
        quasar_daemons = param_creator.create_daemons_parameter()

        keys_yav_version = sdk2.parameters.String(
            'Keys yav version', default='ver-01dyht1f3bck61hcrmwm6hhjcf')

    class BuildConfig(jbl_base.QuasarBaseJblImageBuildTask.BuildConfig):
        @property
        def platform(self):
            return platform.Platform.JBL_LINK_PORTABLE

        @property
        def image_resource_type(self):
            return qrt.QuasarJblLinkPortableImage

        @property
        def ota_resource_type(self):
            return qrt.QuasarJblLinkPortableOTAImage
