import sandbox.sdk2 as sdk2

import sandbox.projects.quasar.utils as quasar_utils
import sandbox.projects.quasar.resource_types as qrt
import sandbox.projects.quasar.resource_types.tv as tv_resource_types
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.image_builds.base_image_build.quasar as quasar_base
import sandbox.projects.quasar.image_builds.base_image_build.amlogic_android as amlogic_android_base
import sandbox.projects.quasar.image_builds.magritte.base as magritte_base


class QuasarBuildMagritteImage(amlogic_android_base.QuasarBuildAmlogicAndroidImage):
    class ArtifactsConfig(object):
        image_resource_type = tv_resource_types.AndroidTvMagritteImage
        ota_resource_type = tv_resource_types.AndroidTvMagritteOtaImage
        target_files_resource = tv_resource_types.AndroidTvMagritteTargetFiles

    class Parameters(amlogic_android_base.QuasarBuildAmlogicAndroidImage.Parameters):
        param_creator = quasar_base.ParameterCreator(quasar_platform.Platform.MAGRITTE)
        custom_manifest = param_creator.create_custom_manifest_parameter()
        ota_max_size = param_creator.create_ota_max_size_parameter()

        # TODO: remove sign and secureboot here (are defined in base class)
        sign = sdk2.parameters.Bool('Build signed image and OTA', default=False)
        secureboot = sdk2.parameters.Bool('Build secureboot image and OTA', default=False)

        # TODO: fix keys
        sign_keys_secret = sdk2.parameters.String(
            'YAV secret with ota keys tarball, should have file keys.tgz',
            default='ver-01g1fyngeckr228pnzeadwqj65')
        secureboot_keys_secret = sdk2.parameters.String(
            'YAV secret with secureboot keys tarball, should have files: aml-user-key.sig',
            default='ver-01fxqfbrwzj80vagj3zwk4q22x')
        tdk_key_secret = sdk2.parameters.String(
            'YAV secret with tdk private key: tdk_keys.tgz',
            default='ver-01fzg58ctqszjgt7v50bhdtgar')
        rabbit_hole_key_secret = sdk2.parameters.String(
            'YAV secret with rabbit_hole rsa private key: rh_public.pem',
            default='ver-01fzzses1z6z6sqprkz1sw97vt')
        avb_key_secret = sdk2.parameters.String(
            'YAV secret with avb rsa private key: avb_private.pem',
            default='ver-01fx7yvgw86kpqmfbvp15bezag')

        _container = quasar_utils.LastStableContainer(
            'Execution container', resource_type=qrt.QuasarYandexSmartDeviceLxcImage)

    class BuildConfig(magritte_base.MagritteBuildConfig):
        downloaded_artifacts_config = tv_resource_types.AndroidTvArtifactsConfig
        downloaded_artifacts = tv_resource_types.AndroidTvArtifacts
