from sandbox import sdk2

import sandbox.projects.quasar.image_builds.base_image_build.tv_mediatek as base
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.platform.mt6681_cv as mt6681_cv
import sandbox.projects.quasar.resource_types.tv as qrt


class QuasarBuildMt6681CvImage(base.QuasarBuildTvMtkCvImageBase):
    """
    Build full image for quasar device and publish it as a resource
    """
    class Parameters(base.QuasarBuildTvMtkCvImageBase.Parameters):
        with sdk2.parameters.String('Product target', required=True) as build_product_target_name:
            for name in mt6681_cv.target_names:
                build_product_target_name.values[name] = None
        secret_device_keys_key = sdk2.parameters.String(
            'Yav secret key with device public key inside', default='yandex_tv_mt6681_cv.pem')

    class BuildConfig(base.QuasarBuildTvMtkCvImageBase.BuildConfig):
        platform = quasar_platform.Platform.YANDEX_TV_MT6681_CV
        platform_board = 'cv_mt6681'
        mediatek_device = 'm5621'
        image_resource_type = qrt.AndroidTvMt6681CvImage
        ota_resource_type = qrt.AndroidTvMt6681CvOtaImage
        uniota_resource_type = qrt.AndroidTvMt6681CvUniotaImage
