import os

from sandbox import sdk2

import sandbox.projects.quasar.image_builds.base_image_build.tv_mediatek as base
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.platform.mt6681_cvte as mt6681_cvte
import sandbox.projects.quasar.resource_types.tv as qrt


class QuasarBuildMt6681CvteImage(base.QuasarBuildTvMtkCvteImageBase):
    """
    Build full image for quasar device and publish it as a resource
    """
    class Parameters(base.QuasarBuildTvMtkCvteImageBase.Parameters):
        with sdk2.parameters.String('Product target', required=True) as build_product_target_name:
            for name in mt6681_cvte.target_names:
                build_product_target_name.values[name] = None
        secret_device_keys_key = sdk2.parameters.String(
            'Yav secret key with device public key inside', default='yandex_tv_mt6681_cvte.pem')

    class BuildConfig(base.QuasarBuildTvMtkCvteImageBase.BuildConfig):
        platform = quasar_platform.Platform.YANDEX_TV_MT6681_CVTE
        platform_board = 'cvte_mt6681'
        mediatek_device = 'm5621'
        image_resource_type = qrt.AndroidTvMt6681CvteImage
        ota_resource_type = qrt.AndroidTvMt6681CvteOtaImage
        uniota_resource_type = qrt.AndroidTvMt6681CvteUniotaImage
        rom_filename_prefix = 'allupgrade506_8GB_1GB'

    def _build_target_report(self):
        if not os.path.isfile(self.config.vendor_config_path):
            self.config.mediatek_device = 'm5621_mcp_1g'
        super(QuasarBuildMt6681CvteImage, self)._build_target_report()
