from sandbox import sdk2

import sandbox.projects.quasar.image_builds.base_image_build.tv_mediatek as base
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.platform.mt9256_cvte as mt9256_cvte
import sandbox.projects.quasar.resource_types.tv as qrt


class QuasarBuildMt9256CvteImage(base.QuasarBuildTvMtkCvteAndroid11ImageBase):
    """
    Build full image for quasar device and publish it as a resource
    """
    class Parameters(base.QuasarBuildTvMtkCvteAndroid11ImageBase.Parameters):
        with sdk2.parameters.String('Product target', required=True) as build_product_target_name:
            for name in mt9256_cvte.target_names:
                build_product_target_name.values[name] = None
        secret_device_keys_key = sdk2.parameters.String(
            'Yav secret key with device public key inside', default='yandex_tv_mt9256_cvte.pem')

    class BuildConfig(base.QuasarBuildTvMtkCvteAndroid11ImageBase.BuildConfig):
        platform = quasar_platform.Platform.YANDEX_TV_MT9256_CVTE
        platform_board = 'cvte_mt9256'
        mediatek_device = 'mt5867'
        default_repository_url = 'ssh://gerrit.yandex-team.ru/cvte9256/manifest'
        image_resource_type = qrt.AndroidTvMt9256CvteImage
        ota_resource_type = qrt.AndroidTvMt9256CvteOtaImage
        uniota_resource_type = qrt.AndroidTvMt9256CvteUniotaImage
        rom_filename_prefix = 'allupgrade516_8GB_1GB'
