from sandbox import sdk2

import sandbox.projects.quasar.image_builds.base_image_build.tv_mediatek as base
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.platform.mt9632_11_cvte as mt9632_11_cvte
import sandbox.projects.quasar.resource_types.tv as qrt


class QuasarBuildMt9632_11CvteImage(base.QuasarBuildTvMtkCvteAndroid11ImageBase):
    """
    Build full image for quasar device and publish it as a resource
    """
    class Parameters(base.QuasarBuildTvMtkCvteAndroid11ImageBase.Parameters):
        with sdk2.parameters.String('Product target', required=True) as build_product_target_name:
            for name in mt9632_11_cvte.target_names:
                build_product_target_name.values[name] = None
        secret_device_keys_key = sdk2.parameters.String(
            'Yav secret key with device public key inside', default='yandex_tv_mt9632_11_cvte.pem')

    class BuildConfig(base.QuasarBuildTvMtkCvteAndroid11ImageBase.BuildConfig):
        platform = quasar_platform.Platform.YANDEX_TV_MT9632_11_CVTE
        platform_board = 'cvte_mt9632_11'
        mediatek_device = 'm7332'
        default_repository_url = 'ssh://gerrit.yandex-team.ru/cvte9256/manifest'
        image_resource_type = qrt.AndroidTvMt9632_11CvteImage
        ota_resource_type = qrt.AndroidTvMt9632_11CvteOtaImage
        uniota_resource_type = qrt.AndroidTvMt9632_11CvteUniotaImage
        rom_filename_prefix = 'allupgrade706_an11_8GB_1P5GB'
